/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channel;

public final class IOUtil {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    private IOUtil() {
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtil.copy(inputStream, outputStream, 16384);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (0 <= (n3 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n3);
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IOUtil.copy(reader, writer, 16384);
    }

    public static void copy(Reader reader, Writer writer, int n2) throws IOException {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (0 <= (n3 = reader.read(cArray))) {
            writer.write(cArray, 0, n3);
        }
        writer.flush();
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        IOUtil.copy(inputStream, writer, 16384);
    }

    public static void copy(InputStream inputStream, Writer writer, int n2) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        IOUtil.copy((Reader)inputStreamReader, writer, n2);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        IOUtil.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string, int n2) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        IOUtil.copy((Reader)inputStreamReader, writer, n2);
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IOUtil.toString(inputStream, 16384);
    }

    public static String toString(InputStream inputStream, int n2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(inputStream, (Writer)stringWriter, n2);
        return stringWriter.toString();
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        return IOUtil.toString(inputStream, string, 16384);
    }

    public static String toString(InputStream inputStream, String string, int n2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(inputStream, (Writer)stringWriter, string, n2);
        return stringWriter.toString();
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return IOUtil.toByteArray(inputStream, 16384);
    }

    public static byte[] toByteArray(InputStream inputStream, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.copy(inputStream, (OutputStream)byteArrayOutputStream, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        IOUtil.copy(reader, outputStream, 16384);
    }

    public static void copy(Reader reader, OutputStream outputStream, int n2) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtil.copy(reader, (Writer)outputStreamWriter, n2);
        outputStreamWriter.flush();
    }

    public static String toString(Reader reader) throws IOException {
        return IOUtil.toString(reader, 16384);
    }

    public static String toString(Reader reader, int n2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(reader, (Writer)stringWriter, n2);
        return stringWriter.toString();
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        return IOUtil.toByteArray(reader, 16384);
    }

    public static byte[] toByteArray(Reader reader, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.copy(reader, (OutputStream)byteArrayOutputStream, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public static void copy(String string, OutputStream outputStream) throws IOException {
        IOUtil.copy(string, outputStream, 16384);
    }

    public static void copy(String string, OutputStream outputStream, int n2) throws IOException {
        StringReader stringReader = new StringReader(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtil.copy((Reader)stringReader, (Writer)outputStreamWriter, n2);
        outputStreamWriter.flush();
    }

    public static void copy(String string, Writer writer) throws IOException {
        writer.write(string);
    }

    public static void bufferedCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        IOUtil.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
        bufferedOutputStream.flush();
    }

    public static byte[] toByteArray(String string) throws IOException {
        return IOUtil.toByteArray(string, 16384);
    }

    public static byte[] toByteArray(String string, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.copy(string, (OutputStream)byteArrayOutputStream, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public static void copy(byte[] byArray, Writer writer) throws IOException {
        IOUtil.copy(byArray, writer, 16384);
    }

    public static void copy(byte[] byArray, Writer writer, int n2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IOUtil.copy((InputStream)byteArrayInputStream, writer, n2);
    }

    public static void copy(byte[] byArray, Writer writer, String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IOUtil.copy((InputStream)byteArrayInputStream, writer, string);
    }

    public static void copy(byte[] byArray, Writer writer, String string, int n2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IOUtil.copy(byteArrayInputStream, writer, string, n2);
    }

    public static String toString(byte[] byArray) throws IOException {
        return IOUtil.toString(byArray, 16384);
    }

    public static String toString(byte[] byArray, int n2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(byArray, (Writer)stringWriter, n2);
        return stringWriter.toString();
    }

    public static String toString(byte[] byArray, String string) throws IOException {
        return IOUtil.toString(byArray, string, 16384);
    }

    public static String toString(byte[] byArray, String string, int n2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(byArray, (Writer)stringWriter, string, n2);
        return stringWriter.toString();
    }

    public static void copy(byte[] byArray, OutputStream outputStream) throws IOException {
        IOUtil.copy(byArray, outputStream, 16384);
    }

    public static void copy(byte[] byArray, OutputStream outputStream, int n2) throws IOException {
        outputStream.write(byArray);
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n2;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(inputStream2);
        int n3 = ((InputStream)bufferedInputStream).read();
        while (0 <= n3) {
            n2 = ((InputStream)bufferedInputStream2).read();
            if (n3 != n2) {
                return false;
            }
            n3 = ((InputStream)bufferedInputStream).read();
        }
        n2 = ((InputStream)bufferedInputStream2).read();
        return 0 > n2;
    }

    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Channel channel) {
        if (channel == null) {
            return;
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

