/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import zz.org.codehaus.plexus.util.reflection.Reflector;
import zz.org.codehaus.plexus.util.reflection.ReflectorException;

public class LineOrientedInterpolatingReader
extends FilterReader {
    public static final String DEFAULT_START_DELIM = "${";
    public static final String DEFAULT_END_DELIM = "}";
    public static final String DEFAULT_ESCAPE_SEQ = "\\";
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final char NEWLINE_CHAR = '\n';
    private final PushbackReader pushbackReader;
    private final Map<String, Object> context;
    private final String startDelim;
    private final String endDelim;
    private final String escapeSeq;
    private final int minExpressionSize;
    private final Reflector reflector;
    private int lineIdx = -1;
    private String line;

    public LineOrientedInterpolatingReader(Reader reader, Map<String, ?> map, String string, String string2, String string3) {
        super(reader);
        this.startDelim = string;
        this.endDelim = string2;
        this.escapeSeq = string3;
        this.minExpressionSize = string.length() + string2.length() + 1;
        this.context = Collections.unmodifiableMap(map);
        this.reflector = new Reflector();
        this.pushbackReader = reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, 1);
    }

    public LineOrientedInterpolatingReader(Reader reader, Map<String, ?> map, String string, String string2) {
        this(reader, map, string, string2, DEFAULT_ESCAPE_SEQ);
    }

    public LineOrientedInterpolatingReader(Reader reader, Map<String, ?> map) {
        this(reader, map, DEFAULT_START_DELIM, DEFAULT_END_DELIM, DEFAULT_ESCAPE_SEQ);
    }

    @Override
    public int read() throws IOException {
        if (this.line == null || this.lineIdx >= this.line.length()) {
            this.readAndInterpolateLine();
        }
        int n2 = -1;
        if (this.line != null && this.lineIdx < this.line.length()) {
            n2 = this.line.charAt(this.lineIdx++);
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        for (int i2 = n2; i2 < n2 + n3 && (n4 = this.read()) > -1; ++i2) {
            cArray[i2] = (char)n4;
            ++n5;
        }
        if (n5 == 0) {
            n5 = -1;
        }
        return n5;
    }

    @Override
    public long skip(long l2) throws IOException {
        int n2;
        long l3 = 0L;
        for (long i2 = 0L; i2 < l2 && (n2 = this.read()) >= 0; ++i2) {
            ++l3;
        }
        return l3;
    }

    private void readAndInterpolateLine() throws IOException {
        String string = this.readLine();
        if (string != null) {
            Set<String> set = this.parseForExpressions(string);
            Map<String, Object> map = this.evaluateExpressions(set);
            String string2 = this.replaceWithInterpolatedValues(string, map);
            if (string2 != null && string2.length() > 0) {
                this.line = string2;
                this.lineIdx = 0;
            }
        } else {
            this.line = null;
            this.lineIdx = -1;
        }
    }

    private String readLine() throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(40);
        boolean bl2 = false;
        while ((n2 = this.pushbackReader.read()) > -1) {
            char c2 = (char)n2;
            if (c2 == '\r') {
                bl2 = true;
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == '\n') {
                stringBuilder.append(c2);
                break;
            }
            if (bl2) {
                this.pushbackReader.unread(c2);
                break;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() < 1) {
            return null;
        }
        return stringBuilder.toString();
    }

    private String replaceWithInterpolatedValues(String string, Map<String, Object> map) {
        String string2 = string;
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            String string3 = entry2.getKey();
            String string4 = String.valueOf(entry2.getValue());
            string2 = this.findAndReplaceUnlessEscaped(string2, string3, string4);
        }
        return string2;
    }

    private Map<String, Object> evaluateExpressions(Set<String> set) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (String string : set) {
            Object object;
            String string2 = string;
            String string3 = string2.substring(this.startDelim.length(), string2.length() - this.endDelim.length());
            String[] stringArray = string3.split("\\.");
            if (stringArray.length <= 0 || (object = this.context.get(stringArray[0])) == null) continue;
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                try {
                    object = this.reflector.getObjectProperty(object, stringArray[i2]);
                    if (object != null) continue;
                }
                catch (ReflectorException reflectorException) {
                    reflectorException.printStackTrace();
                }
                break;
            }
            treeMap.put(string2, object);
        }
        return treeMap;
    }

    private Set<String> parseForExpressions(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            int n2;
            int n3;
            int n4 = -1;
            while ((n3 = this.findDelimiter(string, this.startDelim, n4)) >= 0 && (n2 = this.findDelimiter(string, this.endDelim, n3 + 1)) >= 0) {
                hashSet.add(string.substring(n3, n2 + this.endDelim.length()));
                n4 = n2 + 1;
                if (n4 < string.length() - this.minExpressionSize) continue;
            }
        }
        return hashSet;
    }

    private int findDelimiter(String string, String string2, int n2) {
        int n3;
        int n4 = n2;
        while ((n3 = string.indexOf(string2, n4)) >= 0) {
            int n5 = string.indexOf(this.escapeSeq, n4) + this.escapeSeq.length();
            if (n5 > this.escapeSeq.length() - 1 && n5 == n3) {
                n4 = n3 + 1;
                n3 = -1;
            }
            if (n3 < 0 && n4 < string.length() - this.endDelim.length()) continue;
        }
        return n3;
    }

    private String findAndReplaceUnlessEscaped(String string, String string2, String string3) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.5));
        int n3 = -1;
        while ((n2 = string.indexOf(string2, n3 + 1)) > -1) {
            if (n3 < 0) {
                n3 = 0;
            }
            stringBuilder.append(string, n3, n2);
            int n4 = string.indexOf(this.escapeSeq, n3 + 1);
            if (n4 > -1 && n4 + this.escapeSeq.length() == n2) {
                stringBuilder.setLength(stringBuilder.length() - this.escapeSeq.length());
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(string3);
            }
            if ((n3 = n2 + string2.length()) > -1) continue;
        }
        if (n3 < string.length()) {
            stringBuilder.append(string, n3, string.length());
        }
        return stringBuilder.toString();
    }
}

