/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import zz.org.codehaus.plexus.util.SelectorUtils;

public class MatchPattern {
    private final String source;
    private final String regexPattern;
    private final String separator;
    private final String[] tokenized;
    private final char[][] tokenizedChar;

    private MatchPattern(String string, String string2) {
        this.regexPattern = SelectorUtils.isRegexPrefixedPattern(string) ? string.substring("%regex[".length(), string.length() - "]".length()) : null;
        this.source = SelectorUtils.isAntPrefixedPattern(string) ? string.substring("%ant[".length(), string.length() - "]".length()) : string;
        this.separator = string2;
        this.tokenized = MatchPattern.tokenizePathToString(this.source, string2);
        this.tokenizedChar = new char[this.tokenized.length][];
        for (int i2 = 0; i2 < this.tokenized.length; ++i2) {
            this.tokenizedChar[i2] = this.tokenized[i2].toCharArray();
        }
    }

    public boolean matchPath(String string, boolean bl2) {
        if (this.regexPattern != null) {
            return string.matches(this.regexPattern);
        }
        return SelectorUtils.matchAntPathPattern(this, string, this.separator, bl2);
    }

    boolean matchPath(String string, char[][] cArray, boolean bl2) {
        if (this.regexPattern != null) {
            return string.matches(this.regexPattern);
        }
        return SelectorUtils.matchAntPathPattern(this.getTokenizedPathChars(), cArray, bl2);
    }

    public boolean matchPatternStart(String string, boolean bl2) {
        if (this.regexPattern != null) {
            return true;
        }
        String string2 = this.source.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart(this, string, File.separator, bl2) || SelectorUtils.matchAntPathPatternStart(this, string2, "/", bl2);
    }

    public String[] getTokenizedPathString() {
        return this.tokenized;
    }

    public char[][] getTokenizedPathChars() {
        return this.tokenizedChar;
    }

    public boolean startsWith(String string) {
        return this.source.startsWith(string);
    }

    static String[] tokenizePathToString(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static MatchPattern fromString(String string) {
        return new MatchPattern(string, File.separator);
    }
}

