/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;

public class NioFiles {
    public static boolean isSymbolicLink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    public static void chmod(File file, int n2) throws IOException {
        Path path = file.toPath();
        if (!Files.isSymbolicLink(path)) {
            Files.setPosixFilePermissions(path, NioFiles.getPermissions(n2));
        }
    }

    private static Set<PosixFilePermission> getPermissions(int n2) {
        HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
        if ((n2 & 0x100) > 0) {
            hashSet.add(PosixFilePermission.OWNER_READ);
        }
        if ((n2 & 0x80) > 0) {
            hashSet.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((n2 & 0x40) > 0) {
            hashSet.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((n2 & 0x20) > 0) {
            hashSet.add(PosixFilePermission.GROUP_READ);
        }
        if ((n2 & 0x10) > 0) {
            hashSet.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((n2 & 8) > 0) {
            hashSet.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((n2 & 4) > 0) {
            hashSet.add(PosixFilePermission.OTHERS_READ);
        }
        if ((n2 & 2) > 0) {
            hashSet.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((n2 & 1) > 0) {
            hashSet.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return hashSet;
    }

    public static long getLastModified(File file) throws IOException {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        return basicFileAttributes.lastModifiedTime().toMillis();
    }

    public static File readSymbolicLink(File file) throws IOException {
        Path path = Files.readSymbolicLink(file.toPath());
        return path.toFile();
    }

    public static File createSymbolicLink(File file, File file2) throws IOException {
        Path path = file.toPath();
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            Files.delete(path);
        }
        path = Files.createSymbolicLink(path, file2.toPath(), new FileAttribute[0]);
        return path.toFile();
    }

    public static boolean deleteIfExists(File file) throws IOException {
        return Files.deleteIfExists(file.toPath());
    }

    public static File copy(File file, File file2) throws IOException {
        Path path = Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
        return path.toFile();
    }
}

