/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Os {
    public static final String FAMILY_DOS = "dos";
    public static final String FAMILY_MAC = "mac";
    public static final String FAMILY_NETWARE = "netware";
    public static final String FAMILY_OS2 = "os/2";
    public static final String FAMILY_TANDEM = "tandem";
    public static final String FAMILY_UNIX = "unix";
    public static final String FAMILY_WINDOWS = "windows";
    public static final String FAMILY_WIN9X = "win9x";
    public static final String FAMILY_ZOS = "z/os";
    public static final String FAMILY_OS400 = "os/400";
    public static final String FAMILY_OPENVMS = "openvms";
    private static final Set<String> validFamilies = Os.setValidFamilies();
    private static final String PATH_SEP = System.getProperty("path.separator");
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    public static final String OS_FAMILY = Os.getOsFamily();
    private String family;
    private String name;
    private String version;
    private String arch;

    public Os() {
    }

    public Os(String string) {
        this.setFamily(string);
    }

    private static Set<String> setValidFamilies() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(FAMILY_DOS);
        hashSet.add(FAMILY_MAC);
        hashSet.add(FAMILY_NETWARE);
        hashSet.add(FAMILY_OS2);
        hashSet.add(FAMILY_TANDEM);
        hashSet.add(FAMILY_UNIX);
        hashSet.add(FAMILY_WINDOWS);
        hashSet.add(FAMILY_WIN9X);
        hashSet.add(FAMILY_ZOS);
        hashSet.add(FAMILY_OS400);
        hashSet.add(FAMILY_OPENVMS);
        return hashSet;
    }

    public void setFamily(String string) {
        this.family = string.toLowerCase(Locale.US);
    }

    public void setName(String string) {
        this.name = string.toLowerCase(Locale.US);
    }

    public void setArch(String string) {
        this.arch = string.toLowerCase(Locale.US);
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase(Locale.US);
    }

    public boolean eval() throws Exception {
        return Os.isOs(this.family, this.name, this.arch, this.version);
    }

    public static boolean isFamily(String string) {
        return Os.isOs(string, null, null, null);
    }

    public static boolean isName(String string) {
        return Os.isOs(null, string, null, null);
    }

    public static boolean isArch(String string) {
        return Os.isOs(null, null, string, null);
    }

    public static boolean isVersion(String string) {
        return Os.isOs(null, null, null, string);
    }

    public static boolean isOs(String string, String string2, String string3, String string4) {
        boolean bl2 = false;
        if (string != null || string2 != null || string3 != null || string4 != null) {
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            boolean bl6 = true;
            if (string != null) {
                bl3 = string.equalsIgnoreCase(FAMILY_WINDOWS) ? OS_NAME.contains(FAMILY_WINDOWS) : (string.equalsIgnoreCase(FAMILY_OS2) ? OS_NAME.contains(FAMILY_OS2) : (string.equalsIgnoreCase(FAMILY_NETWARE) ? OS_NAME.contains(FAMILY_NETWARE) : (string.equalsIgnoreCase(FAMILY_DOS) ? PATH_SEP.equals(";") && !Os.isFamily(FAMILY_NETWARE) && !Os.isFamily(FAMILY_WINDOWS) && !Os.isFamily(FAMILY_WIN9X) : (string.equalsIgnoreCase(FAMILY_MAC) ? OS_NAME.contains(FAMILY_MAC) : (string.equalsIgnoreCase(FAMILY_TANDEM) ? OS_NAME.contains("nonstop_kernel") : (string.equalsIgnoreCase(FAMILY_UNIX) ? PATH_SEP.equals(":") && !Os.isFamily(FAMILY_OPENVMS) && (!Os.isFamily(FAMILY_MAC) || OS_NAME.endsWith("x")) : (string.equalsIgnoreCase(FAMILY_WIN9X) ? Os.isFamily(FAMILY_WINDOWS) && (OS_NAME.contains("95") || OS_NAME.contains("98") || OS_NAME.contains("me") || OS_NAME.contains("ce")) : (string.equalsIgnoreCase(FAMILY_ZOS) ? OS_NAME.contains(FAMILY_ZOS) || OS_NAME.contains("os/390") : (string.equalsIgnoreCase(FAMILY_OS400) ? OS_NAME.contains(FAMILY_OS400) : (string.equalsIgnoreCase(FAMILY_OPENVMS) ? OS_NAME.contains(FAMILY_OPENVMS) : OS_NAME.contains(string.toLowerCase(Locale.US))))))))))));
            }
            if (string2 != null) {
                bl4 = string2.toLowerCase(Locale.US).equals(OS_NAME);
            }
            if (string3 != null) {
                bl5 = string3.toLowerCase(Locale.US).equals(OS_ARCH);
            }
            if (string4 != null) {
                bl6 = string4.toLowerCase(Locale.US).equals(OS_VERSION);
            }
            bl2 = bl3 && bl4 && bl5 && bl6;
        }
        return bl2;
    }

    private static String getOsFamily() {
        Set<String> set = null;
        set = !validFamilies.isEmpty() ? validFamilies : Os.setValidFamilies();
        for (String string : set) {
            if (!Os.isFamily(string)) continue;
            return string;
        }
        return null;
    }

    public static boolean isValidFamily(String string) {
        return validFamilies.contains(string);
    }

    public static Set<String> getValidFamilies() {
        return new HashSet<String>(validFamilies);
    }
}

