/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zz.org.codehaus.plexus.util.StringUtils;

public final class ReflectionUtils {
    public static Field getFieldByNameIncludingSuperclasses(String string, Class<?> clazz) {
        Field field;
        block2: {
            field = null;
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Class<?> clazz2 = clazz.getSuperclass();
                if (clazz2 == null) break block2;
                field = ReflectionUtils.getFieldByNameIncludingSuperclasses(string, clazz2);
            }
        }
        return field;
    }

    public static List<Field> getFieldsIncludingSuperclasses(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            arrayList.addAll(ReflectionUtils.getFieldsIncludingSuperclasses(clazz2));
        }
        return arrayList;
    }

    public static Method getSetter(String string, Class<?> clazz) {
        Method[] methodArray = clazz.getMethods();
        string = "set" + StringUtils.capitalizeFirstLetter(string);
        for (Method method : methodArray) {
            if (!method.getName().equals(string) || !ReflectionUtils.isSetter(method)) continue;
            return method;
        }
        return null;
    }

    public static List<Method> getSetters(Class<?> clazz) {
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : methodArray) {
            if (!ReflectionUtils.isSetter(method)) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    public static Class<?> getSetterType(Method method) {
        if (!ReflectionUtils.isSetter(method)) {
            throw new RuntimeException("The method " + method.getDeclaringClass().getName() + "." + method.getName() + " is not a setter.");
        }
        return method.getParameterTypes()[0];
    }

    public static void setVariableValueInObject(Object object, String string, Object object2) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses(string, object.getClass());
        field.setAccessible(true);
        field.set(object, object2);
    }

    public static Object getValueIncludingSuperclasses(String string, Object object) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses(string, object.getClass());
        field.setAccessible(true);
        return field.get(object);
    }

    public static Map<String, Object> getVariablesAndValuesIncludingSuperclasses(Object object) throws IllegalAccessException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReflectionUtils.gatherVariablesAndValuesIncludingSuperclasses(object, hashMap);
        return hashMap;
    }

    public static boolean isSetter(Method method) {
        return method.getReturnType().equals(Void.TYPE) && !Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 1;
    }

    private static void gatherVariablesAndValuesIncludingSuperclasses(Object object, Map<String, Object> map) throws IllegalAccessException {
        Class<?> clazz = object.getClass();
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            map.put(((Field)accessibleObject).getName(), ((Field)accessibleObject).get(object));
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (!Object.class.equals(clazz2)) {
            ReflectionUtils.gatherVariablesAndValuesIncludingSuperclasses(clazz2, map);
        }
    }
}

