/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import zz.org.codehaus.plexus.util.MatchPattern;

public final class SelectorUtils {
    public static final String PATTERN_HANDLER_PREFIX = "[";
    public static final String PATTERN_HANDLER_SUFFIX = "]";
    public static final String REGEX_HANDLER_PREFIX = "%regex[";
    public static final String ANT_HANDLER_PREFIX = "%ant[";
    private static SelectorUtils instance = new SelectorUtils();

    private SelectorUtils() {
    }

    public static SelectorUtils getInstance() {
        return instance;
    }

    public static boolean matchPatternStart(String string, String string2) {
        return SelectorUtils.matchPatternStart(string, string2, true);
    }

    public static boolean matchPatternStart(String string, String string2, boolean bl2) {
        if (SelectorUtils.isRegexPrefixedPattern(string)) {
            return true;
        }
        if (SelectorUtils.isAntPrefixedPattern(string)) {
            string = string.substring(ANT_HANDLER_PREFIX.length(), string.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        String string3 = string2.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart(string, string2, File.separator, bl2) || SelectorUtils.matchAntPathPatternStart(string, string3, "/", bl2);
    }

    static boolean isAntPrefixedPattern(String string) {
        return string.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && string.startsWith(ANT_HANDLER_PREFIX) && string.endsWith(PATTERN_HANDLER_SUFFIX);
    }

    static boolean matchAntPathPatternStart(MatchPattern matchPattern, String string, String string2, boolean bl2) {
        if (SelectorUtils.separatorPatternStartSlashMismatch(matchPattern, string, string2)) {
            return false;
        }
        return SelectorUtils.matchAntPathPatternStart(matchPattern.getTokenizedPathString(), string, string2, bl2);
    }

    static boolean matchAntPathPatternStart(String string, String string2, String string3, boolean bl2) {
        if (SelectorUtils.separatorPatternStartSlashMismatch(string, string2, string3)) {
            return false;
        }
        String[] stringArray = SelectorUtils.tokenizePathToString(string, string3);
        return SelectorUtils.matchAntPathPatternStart(stringArray, string2, string3, bl2);
    }

    private static boolean separatorPatternStartSlashMismatch(String string, String string2, String string3) {
        return string2.startsWith(string3) != string.startsWith(string3);
    }

    private static boolean separatorPatternStartSlashMismatch(MatchPattern matchPattern, String string, String string2) {
        return string.startsWith(string2) != matchPattern.startsWith(string2);
    }

    static boolean matchAntPathPatternStart(String[] stringArray, String string, String string2, boolean bl2) {
        String string3;
        int n2;
        String[] stringArray2 = SelectorUtils.tokenizePathToString(string, string2);
        int n3 = 0;
        int n4 = stringArray.length - 1;
        int n5 = stringArray2.length - 1;
        for (n2 = 0; n3 <= n4 && n2 <= n5 && !(string3 = stringArray[n3]).equals("**"); ++n3, ++n2) {
            if (SelectorUtils.match(string3, stringArray2[n2], bl2)) continue;
            return false;
        }
        return n2 > n5 || n3 <= n4;
    }

    public static boolean matchPath(String string, String string2) {
        return SelectorUtils.matchPath(string, string2, true);
    }

    public static boolean matchPath(String string, String string2, boolean bl2) {
        return SelectorUtils.matchPath(string, string2, File.separator, bl2);
    }

    public static boolean matchPath(String string, String string2, String string3, boolean bl2) {
        if (SelectorUtils.isRegexPrefixedPattern(string)) {
            string = string.substring(REGEX_HANDLER_PREFIX.length(), string.length() - PATTERN_HANDLER_SUFFIX.length());
            return string2.matches(string);
        }
        if (SelectorUtils.isAntPrefixedPattern(string)) {
            string = string.substring(ANT_HANDLER_PREFIX.length(), string.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        return SelectorUtils.matchAntPathPattern(string, string2, string3, bl2);
    }

    static boolean isRegexPrefixedPattern(String string) {
        return string.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && string.startsWith(REGEX_HANDLER_PREFIX) && string.endsWith(PATTERN_HANDLER_SUFFIX);
    }

    static boolean matchAntPathPattern(MatchPattern matchPattern, String string, String string2, boolean bl2) {
        if (SelectorUtils.separatorPatternStartSlashMismatch(matchPattern, string, string2)) {
            return false;
        }
        String[] stringArray = matchPattern.getTokenizedPathString();
        String[] stringArray2 = SelectorUtils.tokenizePathToString(string, string2);
        return SelectorUtils.matchAntPathPattern(stringArray, stringArray2, bl2);
    }

    static boolean matchAntPathPattern(String string, String string2, String string3, boolean bl2) {
        if (SelectorUtils.separatorPatternStartSlashMismatch(string, string2, string3)) {
            return false;
        }
        String[] stringArray = SelectorUtils.tokenizePathToString(string, string3);
        String[] stringArray2 = SelectorUtils.tokenizePathToString(string2, string3);
        return SelectorUtils.matchAntPathPattern(stringArray, stringArray2, bl2);
    }

    static boolean matchAntPathPattern(String[] stringArray, String[] stringArray2, boolean bl2) {
        String string;
        int n2;
        int n3 = 0;
        int n4 = stringArray.length - 1;
        int n5 = stringArray2.length - 1;
        for (n2 = 0; n3 <= n4 && n2 <= n5 && !(string = stringArray[n3]).equals("**"); ++n3, ++n2) {
            if (SelectorUtils.match(string, stringArray2[n2], bl2)) continue;
            return false;
        }
        if (n2 > n5) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                if (stringArray[i2].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (n3 > n4) {
            return false;
        }
        while (n3 <= n4 && n2 <= n5 && !(string = stringArray[n4]).equals("**")) {
            if (!SelectorUtils.match(string, stringArray2[n5], bl2)) {
                return false;
            }
            --n4;
            --n5;
        }
        if (n2 > n5) {
            for (int i3 = n3; i3 <= n4; ++i3) {
                if (stringArray[i3].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (n3 != n4 && n2 <= n5) {
            int n6;
            int n7 = -1;
            for (n6 = n3 + 1; n6 <= n4; ++n6) {
                if (!stringArray[n6].equals("**")) continue;
                n7 = n6;
                break;
            }
            if (n7 == n3 + 1) {
                ++n3;
                continue;
            }
            n6 = n7 - n3 - 1;
            int n8 = n5 - n2 + 1;
            int n9 = -1;
            block6: for (int i4 = 0; i4 <= n8 - n6; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    String string2 = stringArray[n3 + i5 + 1];
                    String string3 = stringArray2[n2 + i4 + i5];
                    if (!SelectorUtils.match(string2, string3, bl2)) continue block6;
                }
                n9 = n2 + i4;
                break;
            }
            if (n9 == -1) {
                return false;
            }
            n3 = n7;
            n2 = n9 + n6;
        }
        for (int i6 = n3; i6 <= n4; ++i6) {
            if (stringArray[i6].equals("**")) continue;
            return false;
        }
        return true;
    }

    static boolean matchAntPathPattern(char[][] cArray, char[][] cArray2, boolean bl2) {
        char[] cArray3;
        int n2;
        int n3 = 0;
        int n4 = cArray.length - 1;
        int n5 = cArray2.length - 1;
        for (n2 = 0; n3 <= n4 && n2 <= n5 && !SelectorUtils.isDoubleStar(cArray3 = cArray[n3]); ++n3, ++n2) {
            if (SelectorUtils.match(cArray3, cArray2[n2], bl2)) continue;
            return false;
        }
        if (n2 > n5) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                if (SelectorUtils.isDoubleStar(cArray[i2])) continue;
                return false;
            }
            return true;
        }
        if (n3 > n4) {
            return false;
        }
        while (n3 <= n4 && n2 <= n5 && !SelectorUtils.isDoubleStar(cArray3 = cArray[n4])) {
            if (!SelectorUtils.match(cArray3, cArray2[n5], bl2)) {
                return false;
            }
            --n4;
            --n5;
        }
        if (n2 > n5) {
            for (int i3 = n3; i3 <= n4; ++i3) {
                if (SelectorUtils.isDoubleStar(cArray[i3])) continue;
                return false;
            }
            return true;
        }
        while (n3 != n4 && n2 <= n5) {
            int n6;
            int n7 = -1;
            for (n6 = n3 + 1; n6 <= n4; ++n6) {
                if (!SelectorUtils.isDoubleStar(cArray[n6])) continue;
                n7 = n6;
                break;
            }
            if (n7 == n3 + 1) {
                ++n3;
                continue;
            }
            n6 = n7 - n3 - 1;
            int n8 = n5 - n2 + 1;
            int n9 = -1;
            block6: for (int i4 = 0; i4 <= n8 - n6; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    char[] cArray4 = cArray[n3 + i5 + 1];
                    char[] cArray5 = cArray2[n2 + i4 + i5];
                    if (!SelectorUtils.match(cArray4, cArray5, bl2)) continue block6;
                }
                n9 = n2 + i4;
                break;
            }
            if (n9 == -1) {
                return false;
            }
            n3 = n7;
            n2 = n9 + n6;
        }
        for (int i6 = n3; i6 <= n4; ++i6) {
            if (SelectorUtils.isDoubleStar(cArray[i6])) continue;
            return false;
        }
        return true;
    }

    private static boolean isDoubleStar(char[] cArray) {
        return cArray != null && cArray.length == 2 && cArray[0] == '*' && cArray[1] == '*';
    }

    public static boolean match(String string, String string2) {
        return SelectorUtils.match(string, string2, true);
    }

    public static boolean match(String string, String string2, boolean bl2) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        return SelectorUtils.match(cArray, cArray2, bl2);
    }

    public static boolean match(char[] cArray, char[] cArray2, boolean bl2) {
        char c2;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = cArray.length - 1;
        int n6 = 0;
        int n7 = cArray2.length - 1;
        boolean bl3 = false;
        char[] cArray3 = cArray;
        int n8 = cArray3.length;
        for (n3 = 0; n3 < n8; ++n3) {
            n2 = cArray3[n3];
            if (n2 != 42) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            if (n5 != n7) {
                return false;
            }
            for (int i2 = 0; i2 <= n5; ++i2) {
                char c3 = cArray[i2];
                if (c3 == '?' || SelectorUtils.equals(c3, cArray2[i2], bl2)) continue;
                return false;
            }
            return true;
        }
        if (n5 == 0) {
            return true;
        }
        while ((c2 = cArray[n4]) != '*' && n6 <= n7) {
            if (c2 != '?' && !SelectorUtils.equals(c2, cArray2[n6], bl2)) {
                return false;
            }
            ++n4;
            ++n6;
        }
        if (n6 > n7) {
            for (int i3 = n4; i3 <= n5; ++i3) {
                if (cArray[i3] == '*') continue;
                return false;
            }
            return true;
        }
        while ((c2 = cArray[n5]) != '*' && n6 <= n7) {
            if (c2 != '?' && !SelectorUtils.equals(c2, cArray2[n7], bl2)) {
                return false;
            }
            --n5;
            --n7;
        }
        if (n6 > n7) {
            for (int i4 = n4; i4 <= n5; ++i4) {
                if (cArray[i4] == '*') continue;
                return false;
            }
            return true;
        }
        while (n4 != n5 && n6 <= n7) {
            int n9 = -1;
            for (n8 = n4 + 1; n8 <= n5; ++n8) {
                if (cArray[n8] != '*') continue;
                n9 = n8;
                break;
            }
            if (n9 == n4 + 1) {
                ++n4;
                continue;
            }
            n8 = n9 - n4 - 1;
            n3 = n7 - n6 + 1;
            n2 = -1;
            block8: for (int i5 = 0; i5 <= n3 - n8; ++i5) {
                for (int i6 = 0; i6 < n8; ++i6) {
                    c2 = cArray[n4 + i6 + 1];
                    if (c2 != '?' && !SelectorUtils.equals(c2, cArray2[n6 + i5 + i6], bl2)) continue block8;
                }
                n2 = n6 + i5;
                break;
            }
            if (n2 == -1) {
                return false;
            }
            n4 = n9;
            n6 = n2 + n8;
        }
        for (int i7 = n4; i7 <= n5; ++i7) {
            if (cArray[i7] == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean equals(char c2, char c3, boolean bl2) {
        if (c2 == c3) {
            return true;
        }
        return !bl2 && (Character.toUpperCase(c2) == Character.toUpperCase(c3) || Character.toLowerCase(c2) == Character.toLowerCase(c3));
    }

    private static String[] tokenizePathToString(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isOutOfDate(File file, File file2, int n2) {
        if (!file.exists()) {
            return false;
        }
        if (!file2.exists()) {
            return true;
        }
        return file.lastModified() - (long)n2 > file2.lastModified();
    }

    public static String removeWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append(stringTokenizer.nextToken());
            }
        }
        return stringBuilder.toString();
    }
}

