/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtils {
    public static String clean(String string) {
        return string == null ? "" : string.trim();
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String deleteWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            stringBuilder.append(string.charAt(i2));
        }
        return stringBuilder.toString();
    }

    public static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static int indexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n2 = stringArray.length;
        int n3 = Integer.MAX_VALUE;
        for (String string2 : stringArray) {
            int n4 = string.indexOf(string2);
            if (n4 == -1 || n4 >= n3) continue;
            n3 = n4;
        }
        return n3 == Integer.MAX_VALUE ? -1 : n3;
    }

    public static int lastIndexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n2 = -1;
        for (String string2 : stringArray) {
            int n3 = string.lastIndexOf(string2);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public static String substring(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > string.length()) {
            return "";
        }
        return string.substring(n2);
    }

    public static String substring(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (n3 < 0) {
            n3 = string.length() + n3;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n3 > string.length()) {
            n3 = string.length();
        }
        if (n2 > n3) {
            return "";
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return string.substring(n2, n3);
    }

    public static String left(String string, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Requested String length " + n2 + " is less than zero");
        }
        if (string == null || string.length() <= n2) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String right(String string, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Requested String length " + n2 + " is less than zero");
        }
        if (string == null || string.length() <= n2) {
            return string;
        }
        return string.substring(string.length() - n2);
    }

    public static String mid(String string, int n2, int n3) {
        if (n2 < 0 || string != null && n2 > string.length()) {
            throw new StringIndexOutOfBoundsException("String index " + n2 + " is out of bounds");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Requested String length " + n3 + " is less than zero");
        }
        if (string == null) {
            return null;
        }
        if (string.length() <= n2 + n3) {
            return string.substring(n2);
        }
        return string.substring(n2, n2 + n3);
    }

    public static String[] split(String string) {
        return StringUtils.split(string, null, -1);
    }

    public static String[] split(String string, String string2) {
        return StringUtils.split(string, string2, -1);
    }

    public static String[] split(String string, String string2, int n2) {
        StringTokenizer stringTokenizer = string2 == null ? new StringTokenizer(string) : new StringTokenizer(string, string2);
        int n3 = stringTokenizer.countTokens();
        if (n2 > 0 && n3 > n2) {
            n3 = n2;
        }
        String[] stringArray = new String[n3];
        int n4 = 0;
        int n5 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n6;
            if (n2 > 0 && n4 == n3 - 1) {
                String string3 = stringTokenizer.nextToken();
                n6 = string.indexOf(string3, n5);
                stringArray[n4] = string.substring(n6);
                break;
            }
            stringArray[n4] = stringTokenizer.nextToken();
            n6 = string.indexOf(stringArray[n4], n5);
            n5 = n6 + stringArray[n4].length();
            ++n4;
        }
        return stringArray;
    }

    public static String concatenate(Object[] objectArray) {
        return StringUtils.join(objectArray, "");
    }

    public static String join(Object[] objectArray, String string) {
        int n2;
        if (string == null) {
            string = "";
        }
        int n3 = (n2 = objectArray.length) == 0 ? 0 : (objectArray[0].toString().length() + string.length()) * n2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(objectArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(Iterator<?> iterator, String string) {
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String replaceOnce(String string, char c2, char c3) {
        return StringUtils.replace(string, c2, c3, 1);
    }

    public static String replace(String string, char c2, char c3) {
        return StringUtils.replace(string, c2, c3, -1);
    }

    public static String replace(String string, char c2, char c3, int n2) {
        return StringUtils.replace(string, String.valueOf(c2), String.valueOf(c3), n2);
    }

    public static String replaceOnce(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, 1);
    }

    public static String replace(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, -1);
    }

    public static String replace(String string, String string2, String string3, int n2) {
        int n3;
        if (string == null || string2 == null || string3 == null || string2.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n4 = 0;
        while ((n3 = string.indexOf(string2, n4)) != -1) {
            stringBuilder.append(string, n4, n3).append(string3);
            n4 = n3 + string2.length();
            if (--n2 != 0) continue;
        }
        stringBuilder.append(string, n4, string.length());
        return stringBuilder.toString();
    }

    public static String overlayString(String string, String string2, int n2, int n3) {
        return new StringBuilder(n2 + string2.length() + string.length() - n3 + 1).append(string, 0, n2).append(string2).append(string, n3, string.length()).toString();
    }

    public static String center(String string, int n2) {
        return StringUtils.center(string, n2, " ");
    }

    public static String center(String string, int n2, String string2) {
        int n3 = string.length();
        int n4 = n2 - n3;
        if (n4 < 1) {
            return string;
        }
        string = StringUtils.leftPad(string, n3 + n4 / 2, string2);
        string = StringUtils.rightPad(string, n2, string2);
        return string;
    }

    public static String chomp(String string) {
        return StringUtils.chomp(string, "\n");
    }

    public static String chomp(String string, String string2) {
        int n2 = string.lastIndexOf(string2);
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String chompLast(String string) {
        return StringUtils.chompLast(string, "\n");
    }

    public static String chompLast(String string, String string2) {
        if (string.length() == 0) {
            return string;
        }
        String string3 = string.substring(string.length() - string2.length());
        if (string2.equals(string3)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String getChomp(String string, String string2) {
        int n2 = string.lastIndexOf(string2);
        if (n2 == string.length() - string2.length()) {
            return string2;
        }
        if (n2 != -1) {
            return string.substring(n2);
        }
        return "";
    }

    public static String prechomp(String string, String string2) {
        int n2 = string.indexOf(string2);
        if (n2 != -1) {
            return string.substring(n2 + string2.length());
        }
        return string;
    }

    public static String getPrechomp(String string, String string2) {
        int n2 = string.indexOf(string2);
        if (n2 != -1) {
            return string.substring(0, n2 + string2.length());
        }
        return "";
    }

    public static String chop(String string) {
        if ("".equals(string)) {
            return "";
        }
        if (string.length() == 1) {
            return "";
        }
        int n2 = string.length() - 1;
        String string2 = string.substring(0, n2);
        char c2 = string.charAt(n2);
        if (c2 == '\n' && string2.charAt(n2 - 1) == '\r') {
            return string2.substring(0, n2 - 1);
        }
        return string2;
    }

    public static String chopNewline(String string) {
        int n2 = string.length() - 1;
        char c2 = string.charAt(n2);
        if (c2 == '\n') {
            if (string.charAt(n2 - 1) == '\r') {
                --n2;
            }
        } else {
            ++n2;
        }
        return string.substring(0, n2);
    }

    public static String escape(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(2 * n2);
        block12: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u0fff') {
                stringBuilder.append("\\u" + Integer.toHexString(c2));
                continue;
            }
            if (c2 > '\u00ff') {
                stringBuilder.append("\\u0" + Integer.toHexString(c2));
                continue;
            }
            if (c2 > '\u007f') {
                stringBuilder.append("\\u00" + Integer.toHexString(c2));
                continue;
            }
            if (c2 < ' ') {
                switch (c2) {
                    case '\b': {
                        stringBuilder.append('\\');
                        stringBuilder.append('b');
                        break;
                    }
                    case '\n': {
                        stringBuilder.append('\\');
                        stringBuilder.append('n');
                        break;
                    }
                    case '\t': {
                        stringBuilder.append('\\');
                        stringBuilder.append('t');
                        break;
                    }
                    case '\f': {
                        stringBuilder.append('\\');
                        stringBuilder.append('f');
                        break;
                    }
                    case '\r': {
                        stringBuilder.append('\\');
                        stringBuilder.append('r');
                        break;
                    }
                    default: {
                        if (c2 > '\u000f') {
                            stringBuilder.append("\\u00" + Integer.toHexString(c2));
                            break;
                        }
                        stringBuilder.append("\\u000" + Integer.toHexString(c2));
                        break;
                    }
                }
                continue;
            }
            switch (c2) {
                case '\'': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\'');
                    continue block12;
                }
                case '\"': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\"');
                    continue block12;
                }
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\\');
                    continue block12;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 * string.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String rightPad(String string, int n2) {
        return StringUtils.rightPad(string, n2, " ");
    }

    public static String rightPad(String string, int n2, String string2) {
        if ((n2 = (n2 - string.length()) / string2.length()) > 0) {
            string = string + StringUtils.repeat(string2, n2);
        }
        return string;
    }

    public static String leftPad(String string, int n2) {
        return StringUtils.leftPad(string, n2, " ");
    }

    public static String leftPad(String string, int n2, String string2) {
        if ((n2 = (n2 - string.length()) / string2.length()) > 0) {
            string = StringUtils.repeat(string2, n2) + string;
        }
        return string;
    }

    public static String strip(String string) {
        return StringUtils.strip(string, null);
    }

    public static String strip(String string, String string2) {
        string = StringUtils.stripStart(string, string2);
        return StringUtils.stripEnd(string, string2);
    }

    public static String[] stripAll(String[] stringArray) {
        return StringUtils.stripAll(stringArray, null);
    }

    public static String[] stripAll(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray2[i2] = StringUtils.strip(stringArray[i2], string);
        }
        return stringArray2;
    }

    public static String stripEnd(String string, String string2) {
        int n2;
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            for (n2 = string.length(); n2 != 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
            }
        } else {
            while (n2 != 0 && string2.indexOf(string.charAt(n2 - 1)) != -1) {
                --n2;
            }
        }
        return string.substring(0, n2);
    }

    public static String stripStart(String string, String string2) {
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (string2 == null) {
            for (n2 = 0; n2 != n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
        } else {
            while (n2 != n3 && string2.indexOf(string.charAt(n2)) != -1) {
                ++n2;
            }
        }
        return string.substring(n2);
    }

    public static String upperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }

    public static String lowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static String uncapitalise(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        return new StringBuilder(string.length()).append(Character.toLowerCase(string.charAt(0))).append(string, 1, string.length()).toString();
    }

    public static String capitalise(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        return new StringBuilder(string.length()).append(Character.toTitleCase(string.charAt(0))).append(string, 1, string.length()).toString();
    }

    public static String swapCase(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            char c3 = Character.isUpperCase(c2) ? Character.toLowerCase(c2) : (Character.isTitleCase(c2) ? Character.toLowerCase(c2) : (Character.isLowerCase(c2) ? (bl2 ? Character.toTitleCase(c2) : Character.toUpperCase(c2)) : c2));
            stringBuilder.append(c3);
            bl2 = Character.isWhitespace(c2);
        }
        return stringBuilder.toString();
    }

    public static String capitaliseAllWords(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) {
                stringBuilder.append(c2);
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuilder.append(Character.toTitleCase(c2));
                bl2 = false;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String uncapitaliseAllWords(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) {
                stringBuilder.append(c2);
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuilder.append(Character.toLowerCase(c2));
                bl2 = false;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String getNestedString(String string, String string2) {
        return StringUtils.getNestedString(string, string2, string2);
    }

    public static String getNestedString(String string, String string2, String string3) {
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.indexOf(string2);
        if (n3 != -1 && (n2 = string.indexOf(string3, n3 + string2.length())) != -1) {
            return string.substring(n3 + string2.length(), n2);
        }
        return null;
    }

    public static int countMatches(String string, String string2) {
        if (string2.equals("")) {
            return 0;
        }
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n3)) != -1) {
            ++n2;
            n3 += string2.length();
        }
        return n2;
    }

    public static boolean isAlpha(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetter(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetter(string.charAt(i2)) || string.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetterOrDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetterOrDigit(string.charAt(i2)) || string.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isDigit(string.charAt(i2)) || string.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static String defaultString(Object object) {
        return StringUtils.defaultString(object, "");
    }

    public static String defaultString(Object object, String string) {
        return object == null ? string : object.toString();
    }

    public static String reverse(String string) {
        if (string == null) {
            return null;
        }
        return new StringBuilder(string).reverse().toString();
    }

    public static String reverseDelimitedString(String string, String string2) {
        Object[] objectArray = StringUtils.split(string, string2);
        StringUtils.reverseArray(objectArray);
        return StringUtils.join(objectArray, string2);
    }

    private static void reverseArray(Object[] objectArray) {
        int n2 = 0;
        for (int i2 = objectArray.length - 1; i2 > n2; --i2, ++n2) {
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n2];
            objectArray[n2] = object;
        }
    }

    public static String abbreviate(String string, int n2) {
        return StringUtils.abbreviate(string, 0, n2);
    }

    public static String abbreviate(String string, int n2, int n3) {
        if (n3 < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (string.length() <= n3) {
            return string;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (string.length() - n2 < n3 - 3) {
            n2 = string.length() - (n3 - 3);
        }
        if (n2 <= 4) {
            return string.substring(0, n3 - 3) + "...";
        }
        if (n3 < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (n2 + (n3 - 3) < string.length()) {
            return "..." + StringUtils.abbreviate(string.substring(n2), n3 - 3);
        }
        return "..." + string.substring(string.length() - (n3 - 3));
    }

    public static String difference(String string, String string2) {
        int n2 = StringUtils.differenceAt(string, string2);
        if (n2 == -1) {
            return "";
        }
        return string2.substring(n2);
    }

    public static int differenceAt(String string, String string2) {
        int n2;
        for (n2 = 0; n2 < string.length() && n2 < string2.length() && string.charAt(n2) == string2.charAt(n2); ++n2) {
        }
        if (n2 < string2.length() || n2 < string.length()) {
            return n2;
        }
        return -1;
    }

    public static String interpolate(String string, Map<?, ?> map) {
        Iterator<?> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            Object obj = map.get(string2);
            if (obj == null) {
                throw new NullPointerException("The value of the key '" + string2 + "' is null.");
            }
            String string3 = obj.toString();
            string = StringUtils.replace(string, "${" + string2 + "}", string3);
            if (string2.contains(" ")) continue;
            string = StringUtils.replace(string, "$" + string2, string3);
        }
        return string;
    }

    public static String removeAndHump(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = (String)stringTokenizer.nextElement();
            stringBuilder.append(StringUtils.capitalizeFirstLetter(string4));
        }
        return stringBuilder.toString();
    }

    public static String capitalizeFirstLetter(String string) {
        char c2 = Character.toTitleCase(string.substring(0, 1).charAt(0));
        String string2 = string.substring(1);
        return c2 + string2;
    }

    public static String lowercaseFirstLetter(String string) {
        char c2 = Character.toLowerCase(string.substring(0, 1).charAt(0));
        String string2 = string.substring(1);
        return c2 + string2;
    }

    public static String addAndDeHump(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (i2 != 0 && Character.isUpperCase(string.charAt(i2))) {
                stringBuilder.append('-');
            }
            stringBuilder.append(string.charAt(i2));
        }
        return stringBuilder.toString().trim().toLowerCase(Locale.ENGLISH);
    }

    public static String quoteAndEscape(String string, char c2) {
        return StringUtils.quoteAndEscape(string, c2, new char[]{c2}, new char[]{' '}, '\\', false);
    }

    public static String quoteAndEscape(String string, char c2, char[] cArray) {
        return StringUtils.quoteAndEscape(string, c2, new char[]{c2}, cArray, '\\', false);
    }

    public static String quoteAndEscape(String string, char c2, char[] cArray, char c3, boolean bl2) {
        return StringUtils.quoteAndEscape(string, c2, cArray, new char[]{' '}, c3, bl2);
    }

    public static String quoteAndEscape(String string, char c2, char[] cArray, char[] cArray2, char c3, boolean bl2) {
        return StringUtils.quoteAndEscape(string, c2, cArray, cArray2, c3 + "%s", bl2);
    }

    public static String quoteAndEscape(String string, char c2, char[] cArray, char[] cArray2, String string2, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (!bl2 && string.startsWith(Character.toString(c2)) && string.endsWith(Character.toString(c2))) {
            return string;
        }
        String string3 = StringUtils.escape(string, cArray, string2);
        boolean bl3 = false;
        if (bl2) {
            bl3 = true;
        } else if (!string3.equals(string)) {
            bl3 = true;
        } else {
            for (char c3 : cArray2) {
                if (string3.indexOf(c3) <= -1) continue;
                bl3 = true;
                break;
            }
        }
        if (bl3) {
            return c2 + string3 + c2;
        }
        return string3;
    }

    public static String escape(String string, char[] cArray, char c2) {
        return StringUtils.escape(string, cArray, c2 + "%s");
    }

    public static String escape(String string, char[] cArray, String string2) {
        if (string == null) {
            return null;
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        Arrays.sort(cArray2);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            int n2 = Arrays.binarySearch(cArray2, c2);
            if (n2 > -1) {
                stringBuilder.append(String.format(string2, Character.valueOf(c2)));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String removeDuplicateWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            boolean bl3 = Character.isWhitespace(c2);
            if (!bl2 || !bl3) {
                stringBuilder.append(c2);
            }
            bl2 = bl3;
        }
        return stringBuilder.toString();
    }

    public static String unifyLineSeparators(String string) {
        return StringUtils.unifyLineSeparators(string, System.getProperty("line.separator"));
    }

    public static String unifyLineSeparators(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        if (!(string2.equals("\n") || string2.equals("\r") || string2.equals("\r\n"))) {
            throw new IllegalArgumentException("Requested line separator is invalid.");
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) == '\r') {
                if (i2 + 1 < n2 && string.charAt(i2 + 1) == '\n') {
                    ++i2;
                }
                stringBuilder.append(string2);
                continue;
            }
            if (string.charAt(i2) == '\n') {
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(string.charAt(i2));
        }
        return stringBuilder.toString();
    }

    public static boolean contains(String string, char c2) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        return string.indexOf(c2) >= 0;
    }

    public static boolean contains(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.contains(string2);
    }
}

