/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.util.ArrayList;

public class SweeperPool {
    private static final boolean DEBUG = false;
    private transient Sweeper sweeper;
    private transient int maxSize;
    private transient int minSize;
    private int triggerSize;
    private ArrayList<Object> pooledObjects;
    private boolean shuttingDown = false;

    public SweeperPool(int n2, int n3, int n4, int n5, int n6) {
        this.maxSize = this.saneConvert(n2);
        this.minSize = this.saneConvert(n3);
        this.triggerSize = this.saneConvert(n6);
        this.pooledObjects = new ArrayList(n4);
        if (n5 > 0) {
            this.sweeper = new Sweeper(this, n5);
            this.sweeper.start();
        }
    }

    private int saneConvert(int n2) {
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    public synchronized Object get() {
        if (this.pooledObjects.size() == 0 || this.shuttingDown) {
            return null;
        }
        Object object = this.pooledObjects.remove(0);
        this.objectRetrieved(object);
        return object;
    }

    public synchronized boolean put(Object object) {
        this.objectAdded(object);
        if (object != null && this.pooledObjects.size() < this.maxSize && !this.shuttingDown) {
            this.pooledObjects.add(object);
            return true;
        }
        if (object != null) {
            this.objectDisposed(object);
        }
        return false;
    }

    public synchronized int getSize() {
        return this.pooledObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.shuttingDown = true;
        if (this.sweeper != null) {
            this.sweeper.stop();
            try {
                this.sweeper.join();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Unexpected exception occurred: ");
                interruptedException.printStackTrace();
            }
        }
        SweeperPool sweeperPool = this;
        synchronized (sweeperPool) {
            Object[] objectArray;
            for (Object object : objectArray = this.pooledObjects.toArray()) {
                this.objectDisposed(object);
            }
            this.pooledObjects.clear();
        }
    }

    boolean isDisposed() {
        if (!this.shuttingDown) {
            return false;
        }
        if (this.sweeper == null) {
            return true;
        }
        return this.sweeper.hasStopped();
    }

    public synchronized void trim() {
        if (this.triggerSize > 0 && this.pooledObjects.size() >= this.triggerSize || this.maxSize > 0 && this.pooledObjects.size() >= this.maxSize) {
            while (this.pooledObjects.size() > this.minSize) {
                this.objectDisposed(this.pooledObjects.remove(0));
            }
        }
    }

    public void objectDisposed(Object object) {
    }

    public void objectAdded(Object object) {
    }

    public void objectRetrieved(Object object) {
    }

    private static class Sweeper
    implements Runnable {
        private final transient SweeperPool pool;
        private transient boolean service = false;
        private final transient int sweepInterval;
        private transient Thread t = null;

        public Sweeper(SweeperPool sweeperPool, int n2) {
            this.sweepInterval = n2;
            this.pool = sweeperPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.debug("started");
            if (this.sweepInterval > 0) {
                Sweeper sweeper = this;
                synchronized (sweeper) {
                    while (this.service) {
                        try {
                            this.wait(this.sweepInterval * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runSweep();
                    }
                }
            }
            this.debug("stopped");
        }

        public void start() {
            if (!this.service) {
                this.service = true;
                this.t = new Thread(this);
                this.t.setName("Sweeper");
                this.t.start();
            }
        }

        public synchronized void stop() {
            this.service = false;
            this.notifyAll();
        }

        void join() throws InterruptedException {
            this.t.join();
        }

        boolean hasStopped() {
            return !this.service && !this.t.isAlive();
        }

        private final void debug(String string) {
        }

        private void runSweep() {
            this.debug("runningSweep. time=" + System.currentTimeMillis());
            this.pool.trim();
        }
    }
}

