/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.cli;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import zz.org.codehaus.plexus.util.Os;
import zz.org.codehaus.plexus.util.StringUtils;
import zz.org.codehaus.plexus.util.cli.AbstractStreamHandler;
import zz.org.codehaus.plexus.util.cli.CommandLineCallable;
import zz.org.codehaus.plexus.util.cli.CommandLineException;
import zz.org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import zz.org.codehaus.plexus.util.cli.Commandline;
import zz.org.codehaus.plexus.util.cli.ShutdownHookUtils;
import zz.org.codehaus.plexus.util.cli.StreamConsumer;
import zz.org.codehaus.plexus.util.cli.StreamFeeder;
import zz.org.codehaus.plexus.util.cli.StreamPumper;

public abstract class CommandLineUtils {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long NANOS_PER_SECOND = 1000000000L;

    public static int executeCommandLine(Commandline commandline, StreamConsumer streamConsumer, StreamConsumer streamConsumer2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(commandline, null, streamConsumer, streamConsumer2, 0);
    }

    public static int executeCommandLine(Commandline commandline, StreamConsumer streamConsumer, StreamConsumer streamConsumer2, int n2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(commandline, null, streamConsumer, streamConsumer2, n2);
    }

    public static int executeCommandLine(Commandline commandline, InputStream inputStream, StreamConsumer streamConsumer, StreamConsumer streamConsumer2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(commandline, inputStream, streamConsumer, streamConsumer2, 0);
    }

    public static int executeCommandLine(Commandline commandline, InputStream inputStream, StreamConsumer streamConsumer, StreamConsumer streamConsumer2, int n2) throws CommandLineException {
        CommandLineCallable commandLineCallable = CommandLineUtils.executeCommandLineAsCallable(commandline, inputStream, streamConsumer, streamConsumer2, n2);
        return commandLineCallable.call();
    }

    public static CommandLineCallable executeCommandLineAsCallable(Commandline commandline, final InputStream inputStream, final StreamConsumer streamConsumer, final StreamConsumer streamConsumer2, final int n2) throws CommandLineException {
        if (commandline == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        final Process process = commandline.execute();
        final Thread thread = new Thread(){
            {
                this.setName("CommandLineUtils process shutdown hook");
                this.setContextClassLoader(null);
            }

            @Override
            public void run() {
                process.destroy();
            }
        };
        ShutdownHookUtils.addShutDownHook(thread);
        return new CommandLineCallable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws CommandLineException {
                AbstractStreamHandler abstractStreamHandler = null;
                AbstractStreamHandler abstractStreamHandler2 = null;
                AbstractStreamHandler abstractStreamHandler3 = null;
                boolean bl2 = false;
                try {
                    int n22;
                    if (inputStream != null) {
                        abstractStreamHandler = new StreamFeeder(inputStream, process.getOutputStream());
                        abstractStreamHandler.start();
                    }
                    abstractStreamHandler2 = new StreamPumper(process.getInputStream(), streamConsumer);
                    abstractStreamHandler2.start();
                    abstractStreamHandler3 = new StreamPumper(process.getErrorStream(), streamConsumer2);
                    abstractStreamHandler3.start();
                    if (n2 <= 0) {
                        n22 = process.waitFor();
                    } else {
                        long l2 = System.nanoTime();
                        long l3 = l2 + 1000000000L * (long)n2;
                        while (CommandLineUtils.isAlive(process) && System.nanoTime() < l3) {
                            Thread.sleep(999L);
                        }
                        if (CommandLineUtils.isAlive(process)) {
                            throw new InterruptedException(String.format("Process timed out after %d seconds.", n2));
                        }
                        n22 = process.exitValue();
                    }
                    if (abstractStreamHandler != null) {
                        abstractStreamHandler.waitUntilDone();
                    }
                    abstractStreamHandler2.waitUntilDone();
                    abstractStreamHandler3.waitUntilDone();
                    if (abstractStreamHandler != null) {
                        ((StreamFeeder)abstractStreamHandler).close();
                        CommandLineUtils.handleException((StreamFeeder)abstractStreamHandler, "stdin");
                    }
                    ((StreamPumper)abstractStreamHandler2).close();
                    CommandLineUtils.handleException((StreamPumper)abstractStreamHandler2, "stdout");
                    ((StreamPumper)abstractStreamHandler3).close();
                    CommandLineUtils.handleException((StreamPumper)abstractStreamHandler3, "stderr");
                    bl2 = true;
                    Integer n3 = n22;
                    return n3;
                }
                catch (InterruptedException interruptedException) {
                    throw new CommandLineTimeOutException("Error while executing external command, process killed.", interruptedException);
                }
                finally {
                    if (abstractStreamHandler != null) {
                        abstractStreamHandler.disable();
                    }
                    if (abstractStreamHandler2 != null) {
                        abstractStreamHandler2.disable();
                    }
                    if (abstractStreamHandler3 != null) {
                        abstractStreamHandler3.disable();
                    }
                    try {
                        ShutdownHookUtils.removeShutdownHook(thread);
                        thread.run();
                    }
                    finally {
                        try {
                            if (abstractStreamHandler != null) {
                                ((StreamFeeder)abstractStreamHandler).close();
                                if (bl2) {
                                    bl2 = false;
                                    CommandLineUtils.handleException((StreamFeeder)abstractStreamHandler, "stdin");
                                    bl2 = true;
                                }
                            }
                        }
                        finally {
                            try {
                                if (abstractStreamHandler2 != null) {
                                    ((StreamPumper)abstractStreamHandler2).close();
                                    if (bl2) {
                                        bl2 = false;
                                        CommandLineUtils.handleException((StreamPumper)abstractStreamHandler2, "stdout");
                                        bl2 = true;
                                    }
                                }
                            }
                            finally {
                                if (abstractStreamHandler3 != null) {
                                    ((StreamPumper)abstractStreamHandler3).close();
                                    if (bl2) {
                                        CommandLineUtils.handleException((StreamPumper)abstractStreamHandler3, "stderr");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        };
    }

    private static void handleException(StreamPumper streamPumper, String string) throws CommandLineException {
        if (streamPumper.getException() != null) {
            throw new CommandLineException(String.format("Failure processing %s.", string), streamPumper.getException());
        }
    }

    private static void handleException(StreamFeeder streamFeeder, String string) throws CommandLineException {
        if (streamFeeder.getException() != null) {
            throw new CommandLineException(String.format("Failure processing %s.", string), streamFeeder.getException());
        }
    }

    public static Properties getSystemEnvVars() throws IOException {
        return CommandLineUtils.getSystemEnvVars(!Os.isFamily("windows"));
    }

    public static Properties getSystemEnvVars(boolean bl2) throws IOException {
        Properties properties = new Properties();
        Map<String, String> map = System.getenv();
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            if (!bl2) {
                string = string.toUpperCase(Locale.ENGLISH);
            }
            properties.put(string, string2);
        }
        return properties;
    }

    public static boolean isAlive(Process process) {
        if (process == null) {
            return false;
        }
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public static String[] translateCommandline(String string) throws Exception {
        Object[] objectArray;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = 2;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        Vector<String> vector = new Vector<String>();
        StringBuilder stringBuilder = new StringBuilder();
        block4: while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            switch (n3) {
                case 1: {
                    if ("'".equals(objectArray)) {
                        n3 = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)objectArray);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(objectArray)) {
                        n3 = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)objectArray);
                    continue block4;
                }
            }
            if ("'".equals(objectArray)) {
                n3 = 1;
                continue;
            }
            if ("\"".equals(objectArray)) {
                n3 = 2;
                continue;
            }
            if (" ".equals(objectArray)) {
                if (stringBuilder.length() == 0) continue;
                vector.addElement(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append((String)objectArray);
        }
        if (stringBuilder.length() != 0) {
            vector.addElement(stringBuilder.toString());
        }
        if (n3 == 1 || n3 == 2) {
            throw new CommandLineException("unbalanced quotes in " + string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String quote(String string) throws CommandLineException {
        return CommandLineUtils.quote(string, false, false, true);
    }

    public static String quote(String string, boolean bl2) throws CommandLineException {
        return CommandLineUtils.quote(string, false, false, bl2);
    }

    public static String quote(String string, boolean bl2, boolean bl3, boolean bl4) throws CommandLineException {
        if (string.contains("\"")) {
            if (string.contains("'")) {
                throw new CommandLineException("Can't handle single and double quotes in same argument");
            }
            if (bl2) {
                return "\\'" + string + "\\'";
            }
            if (bl4) {
                return '\'' + string + '\'';
            }
        } else if (string.contains("'")) {
            if (bl3) {
                return "\\\"" + string + "\\\"";
            }
            if (bl4) {
                return '\"' + string + '\"';
            }
        } else if (string.contains(" ")) {
            if (bl3) {
                return "\\\"" + string + "\\\"";
            }
            return '\"' + string + '\"';
        }
        return string;
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(' ');
            }
            try {
                stringBuilder.append(StringUtils.quoteAndEscape(stringArray[i2], '\"'));
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error quoting argument: " + exception.getMessage());
            }
        }
        return stringBuilder.toString();
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        @Override
        public void consumeLine(String string) {
            this.string.append(string).append(this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

