/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.cli;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import zz.org.codehaus.plexus.util.Os;
import zz.org.codehaus.plexus.util.StringUtils;
import zz.org.codehaus.plexus.util.cli.Arg;
import zz.org.codehaus.plexus.util.cli.CommandLineException;
import zz.org.codehaus.plexus.util.cli.CommandLineUtils;
import zz.org.codehaus.plexus.util.cli.shell.BourneShell;
import zz.org.codehaus.plexus.util.cli.shell.CmdShell;
import zz.org.codehaus.plexus.util.cli.shell.CommandShell;
import zz.org.codehaus.plexus.util.cli.shell.Shell;

public class Commandline
implements Cloneable {
    protected static final String OS_NAME = "os.name";
    protected static final String WINDOWS = "Windows";
    protected Vector<Arg> arguments = new Vector();
    protected Map<String, String> envVars = Collections.synchronizedMap(new LinkedHashMap());
    private long pid = -1L;
    private Shell shell;
    protected String executable;
    private File workingDir;

    public Commandline(String string, Shell shell) {
        this.shell = shell;
        String[] stringArray = new String[]{};
        try {
            stringArray = CommandLineUtils.translateCommandline(string);
        }
        catch (Exception exception) {
            System.err.println("Error translating Commandline.");
        }
        if (stringArray != null && stringArray.length > 0) {
            this.setExecutable(stringArray[0]);
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                this.createArgument().setValue(stringArray[i2]);
            }
        }
    }

    public Commandline(Shell shell) {
        this.shell = shell;
    }

    public Commandline(String string) {
        this.setDefaultShell();
        String[] stringArray = new String[]{};
        try {
            stringArray = CommandLineUtils.translateCommandline(string);
        }
        catch (Exception exception) {
            System.err.println("Error translating Commandline.");
        }
        if (stringArray != null && stringArray.length > 0) {
            this.setExecutable(stringArray[0]);
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                this.createArgument().setValue(stringArray[i2]);
            }
        }
    }

    public Commandline() {
        this.setDefaultShell();
    }

    public long getPid() {
        if (this.pid == -1L) {
            this.pid = Long.parseLong(String.valueOf(System.currentTimeMillis()));
        }
        return this.pid;
    }

    public void setPid(long l2) {
        this.pid = l2;
    }

    private void setDefaultShell() {
        if (Os.isFamily("windows")) {
            if (Os.isFamily("win9x")) {
                this.setShell(new CommandShell());
            } else {
                this.setShell(new CmdShell());
            }
        } else {
            this.setShell(new BourneShell());
        }
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean bl2) {
        Argument argument = new Argument();
        if (bl2) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public Arg createArg() {
        return this.createArg(false);
    }

    public Arg createArg(boolean bl2) {
        Argument argument = new Argument();
        if (bl2) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public void addArg(Arg arg) {
        this.addArg(arg, false);
    }

    public void addArg(Arg arg, boolean bl2) {
        if (bl2) {
            this.arguments.insertElementAt(arg, 0);
        } else {
            this.arguments.addElement(arg);
        }
    }

    public void setExecutable(String string) {
        this.shell.setExecutable(string);
        this.executable = string;
    }

    public String getLiteralExecutable() {
        return this.executable;
    }

    public String getExecutable() {
        String string = this.shell.getExecutable();
        if (string == null) {
            string = this.executable;
        }
        return string;
    }

    public void addArguments(String[] stringArray) {
        for (String string : stringArray) {
            this.createArgument().setValue(string);
        }
    }

    public void addEnvironment(String string, String string2) {
        this.envVars.put(string, string2);
    }

    public void addSystemEnvironment() throws Exception {
        Properties properties = CommandLineUtils.getSystemEnvVars();
        for (Object object : properties.keySet()) {
            String string = (String)object;
            if (this.envVars.containsKey(string)) continue;
            this.addEnvironment(string, properties.getProperty(string));
        }
    }

    public String[] getEnvironmentVariables() throws CommandLineException {
        try {
            this.addSystemEnvironment();
        }
        catch (Exception exception) {
            throw new CommandLineException("Error setting up environmental variables", exception);
        }
        String[] stringArray = new String[this.envVars.size()];
        int n2 = 0;
        Iterator<String> iterator = this.envVars.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            String string3 = this.envVars.get(string2);
            stringArray[n2] = string2 + "=" + string3;
            ++n2;
        }
        return stringArray;
    }

    public String[] getCommandline() {
        if (Os.isFamily("windows")) {
            return this.getShellCommandline();
        }
        String[] stringArray = this.getArguments();
        String string = this.getLiteralExecutable();
        if (string == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public String[] getShellCommandline() {
        this.verifyShellState();
        return this.getShell().getShellCommandLine(this.getArguments()).toArray(new String[0]);
    }

    public String[] getArguments() {
        Vector<String> vector = new Vector<String>(this.arguments.size() * 2);
        for (int i2 = 0; i2 < this.arguments.size(); ++i2) {
            Arg arg = this.arguments.elementAt(i2);
            String[] stringArray = arg.getParts();
            if (stringArray == null) continue;
            for (String string : stringArray) {
                vector.addElement(string);
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        return StringUtils.join(this.getShellCommandline(), " ");
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() {
        Commandline commandline = new Commandline((Shell)this.shell.clone());
        commandline.executable = this.executable;
        commandline.workingDir = this.workingDir;
        commandline.addArguments(this.getArguments());
        return commandline;
    }

    public void clear() {
        this.executable = null;
        this.workingDir = null;
        this.shell.setExecutable(null);
        this.shell.clearArguments();
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public void setWorkingDirectory(String string) {
        this.shell.setWorkingDirectory(string);
        this.workingDir = new File(string);
    }

    public void setWorkingDirectory(File file) {
        this.shell.setWorkingDirectory(file);
        this.workingDir = file;
    }

    public File getWorkingDirectory() {
        File file = this.shell.getWorkingDirectory();
        if (file == null) {
            file = this.workingDir;
        }
        return file;
    }

    public Process execute() throws CommandLineException {
        Process process;
        this.verifyShellState();
        String[] stringArray = this.getEnvironmentVariables();
        File file = this.shell.getWorkingDirectory();
        try {
            if (file == null) {
                process = Runtime.getRuntime().exec(this.getCommandline(), stringArray, file);
            } else {
                if (!file.exists()) {
                    throw new CommandLineException("Working directory \"" + file.getPath() + "\" does not exist!");
                }
                if (!file.isDirectory()) {
                    throw new CommandLineException("Path \"" + file.getPath() + "\" does not specify a directory.");
                }
                process = Runtime.getRuntime().exec(this.getCommandline(), stringArray, file);
            }
        }
        catch (IOException iOException) {
            throw new CommandLineException("Error while executing process.", iOException);
        }
        return process;
    }

    private void verifyShellState() {
        if (this.shell.getWorkingDirectory() == null) {
            this.shell.setWorkingDirectory(this.workingDir);
        }
        if (this.shell.getOriginalExecutable() == null) {
            this.shell.setExecutable(this.executable);
        }
    }

    public Properties getSystemEnvVars() throws Exception {
        return CommandLineUtils.getSystemEnvVars();
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Shell getShell() {
        return this.shell;
    }

    public static String[] translateCommandline(String string) throws Exception {
        return CommandLineUtils.translateCommandline(string);
    }

    public static String quoteArgument(String string) throws CommandLineException {
        return CommandLineUtils.quote(string);
    }

    public static String toString(String[] stringArray) {
        return CommandLineUtils.toString(stringArray);
    }

    public static class Argument
    implements Arg {
        private String[] parts;

        @Override
        public void setValue(String string) {
            if (string != null) {
                this.parts = new String[]{string};
            }
        }

        @Override
        public void setLine(String string) {
            if (string == null) {
                return;
            }
            try {
                this.parts = CommandLineUtils.translateCommandline(string);
            }
            catch (Exception exception) {
                System.err.println("Error translating Commandline.");
            }
        }

        @Override
        public void setFile(File file) {
            this.parts = new String[]{file.getAbsolutePath()};
        }

        @Override
        public String[] getParts() {
            return this.parts;
        }
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int n2) {
            this.position = n2;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.getLiteralExecutable() == null ? 0 : 1;
                for (int i2 = 0; i2 < this.position; ++i2) {
                    Arg arg = Commandline.this.arguments.elementAt(i2);
                    this.realPos += arg.getParts().length;
                }
            }
            return this.realPos;
        }
    }
}

