/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import zz.org.codehaus.plexus.util.cli.AbstractStreamHandler;
import zz.org.codehaus.plexus.util.cli.StreamConsumer;

public class StreamPumper
extends AbstractStreamHandler {
    private final BufferedReader in;
    private final StreamConsumer consumer;
    private final PrintWriter out;
    private volatile Exception exception = null;
    private static final int SIZE = 1024;

    public StreamPumper(InputStream inputStream) {
        this(inputStream, (StreamConsumer)null);
    }

    public StreamPumper(InputStream inputStream, StreamConsumer streamConsumer) {
        this(inputStream, null, streamConsumer);
    }

    public StreamPumper(InputStream inputStream, PrintWriter printWriter) {
        this(inputStream, printWriter, null);
    }

    public StreamPumper(InputStream inputStream, PrintWriter printWriter, StreamConsumer streamConsumer) {
        this.in = new BufferedReader(new InputStreamReader(inputStream), 1024);
        this.out = printWriter;
        this.consumer = streamConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl2 = this.out != null ? this.out.checkError() : false;
        try {
            Object object = this.in.readLine();
            while (object != null) {
                try {
                    if (this.exception == null && this.consumer != null && !this.isDisabled()) {
                        this.consumer.consumeLine((String)object);
                    }
                }
                catch (Exception exception) {
                    this.exception = exception;
                }
                if (this.out != null && !bl2) {
                    this.out.println((String)object);
                    this.out.flush();
                    if (this.out.checkError()) {
                        bl2 = true;
                        try {
                            throw new IOException(String.format("Failure printing line '%s'.", object));
                        }
                        catch (IOException iOException) {
                            this.exception = iOException;
                        }
                    }
                }
                object = this.in.readLine();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
        finally {
            block29: {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block29;
                    this.exception = iOException;
                }
            }
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.setDone();
                this.notifyAll();
            }
        }
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
            if (this.out.checkError() && this.exception == null) {
                try {
                    throw new IOException("Failure flushing output.");
                }
                catch (IOException iOException) {
                    this.exception = iOException;
                }
            }
        }
    }

    public void close() {
        if (this.out != null) {
            this.out.close();
            if (this.out.checkError() && this.exception == null) {
                try {
                    throw new IOException("Failure closing output.");
                }
                catch (IOException iOException) {
                    this.exception = iOException;
                }
            }
        }
    }

    public Exception getException() {
        return this.exception;
    }
}

