/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.cli.shell;

import java.util.ArrayList;
import java.util.List;
import zz.org.codehaus.plexus.util.Os;
import zz.org.codehaus.plexus.util.cli.shell.Shell;

public class BourneShell
extends Shell {
    public BourneShell() {
        this(false);
    }

    public BourneShell(boolean bl2) {
        this.setUnconditionalQuoting(true);
        this.setShellCommand("/bin/sh");
        this.setArgumentQuoteDelimiter('\'');
        this.setExecutableQuoteDelimiter('\'');
        this.setSingleQuotedArgumentEscaped(true);
        this.setSingleQuotedExecutableEscaped(false);
        this.setQuotedExecutableEnabled(true);
        this.setArgumentEscapePattern("'\\%s'");
        if (bl2) {
            this.addShellArg("-l");
        }
    }

    @Override
    public String getExecutable() {
        if (Os.isFamily("windows")) {
            return super.getExecutable();
        }
        return this.quoteOneItem(super.getOriginalExecutable(), true);
    }

    @Override
    public List<String> getShellArgsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = super.getShellArgsList();
        if (list != null && !list.isEmpty()) {
            arrayList.addAll(list);
        }
        arrayList.add("-c");
        return arrayList;
    }

    @Override
    public String[] getShellArgs() {
        String[] stringArray = super.getShellArgs();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray.length > 0 && !stringArray[stringArray.length - 1].equals("-c")) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = "-c";
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @Override
    protected String getExecutionPreamble() {
        if (this.getWorkingDirectoryAsString() == null) {
            return null;
        }
        String string = this.getWorkingDirectoryAsString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cd ");
        stringBuilder.append(this.quoteOneItem(string, false));
        stringBuilder.append(" && ");
        return stringBuilder.toString();
    }

    @Override
    protected String quoteOneItem(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'");
        stringBuilder.append(string.replace("'", "'\"'\"'"));
        stringBuilder.append("'");
        return stringBuilder.toString();
    }
}

