/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.cli.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import zz.org.codehaus.plexus.util.StringUtils;

public class Shell
implements Cloneable {
    private static final char[] DEFAULT_QUOTING_TRIGGER_CHARS = new char[]{' '};
    private String shellCommand;
    private List<String> shellArgs = new ArrayList<String>();
    private boolean quotedArgumentsEnabled = true;
    private boolean unconditionallyQuote = false;
    private String executable;
    private String workingDir;
    private boolean quotedExecutableEnabled = true;
    private boolean doubleQuotedArgumentEscaped = false;
    private boolean singleQuotedArgumentEscaped = false;
    private boolean doubleQuotedExecutableEscaped = false;
    private boolean singleQuotedExecutableEscaped = false;
    private char argQuoteDelimiter = (char)34;
    private char exeQuoteDelimiter = (char)34;
    private String argumentEscapePattern = "\\%s";

    public void setUnconditionalQuoting(boolean bl2) {
        this.unconditionallyQuote = bl2;
    }

    public void setShellCommand(String string) {
        this.shellCommand = string;
    }

    public String getShellCommand() {
        return this.shellCommand;
    }

    public void setShellArgs(String[] stringArray) {
        this.shellArgs.clear();
        this.shellArgs.addAll(Arrays.asList(stringArray));
    }

    public String[] getShellArgs() {
        if (this.shellArgs == null || this.shellArgs.isEmpty()) {
            return null;
        }
        return this.shellArgs.toArray(new String[this.shellArgs.size()]);
    }

    public List<String> getCommandLine(String string, String[] stringArray) {
        return this.getRawCommandLine(string, stringArray);
    }

    protected String quoteOneItem(String string, boolean bl2) {
        char[] cArray = this.getEscapeChars(this.isSingleQuotedExecutableEscaped(), this.isDoubleQuotedExecutableEscaped());
        return StringUtils.quoteAndEscape(string, bl2 ? this.getExecutableQuoteDelimiter() : this.getArgumentQuoteDelimiter(), cArray, this.getQuotingTriggerChars(), '\\', this.unconditionallyQuote);
    }

    protected List<String> getRawCommandLine(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            String object = this.getExecutionPreamble();
            if (object != null) {
                stringBuilder.append(object);
            }
            if (this.isQuotedExecutableEnabled()) {
                stringBuilder.append(this.quoteOneItem(this.getOriginalExecutable(), true));
            } else {
                stringBuilder.append(this.getExecutable());
            }
        }
        for (String string2 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (this.isQuotedArgumentsEnabled()) {
                stringBuilder.append(this.quoteOneItem(string2, false));
                continue;
            }
            stringBuilder.append(string2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected char[] getQuotingTriggerChars() {
        return DEFAULT_QUOTING_TRIGGER_CHARS;
    }

    protected String getExecutionPreamble() {
        return null;
    }

    protected char[] getEscapeChars(boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(2);
        if (bl2) {
            stringBuilder.append('\'');
        }
        if (bl3) {
            stringBuilder.append('\"');
        }
        char[] cArray = new char[stringBuilder.length()];
        stringBuilder.getChars(0, stringBuilder.length(), cArray, 0);
        return cArray;
    }

    protected boolean isDoubleQuotedArgumentEscaped() {
        return this.doubleQuotedArgumentEscaped;
    }

    protected boolean isSingleQuotedArgumentEscaped() {
        return this.singleQuotedArgumentEscaped;
    }

    protected boolean isDoubleQuotedExecutableEscaped() {
        return this.doubleQuotedExecutableEscaped;
    }

    protected boolean isSingleQuotedExecutableEscaped() {
        return this.singleQuotedExecutableEscaped;
    }

    protected void setArgumentQuoteDelimiter(char c2) {
        this.argQuoteDelimiter = c2;
    }

    protected char getArgumentQuoteDelimiter() {
        return this.argQuoteDelimiter;
    }

    protected void setExecutableQuoteDelimiter(char c2) {
        this.exeQuoteDelimiter = c2;
    }

    protected char getExecutableQuoteDelimiter() {
        return this.exeQuoteDelimiter;
    }

    protected void setArgumentEscapePattern(String string) {
        this.argumentEscapePattern = string;
    }

    protected String getArgumentEscapePattern() {
        return this.argumentEscapePattern;
    }

    public List<String> getShellCommandLine(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getShellCommand() != null) {
            arrayList.add(this.getShellCommand());
        }
        if (this.getShellArgs() != null) {
            arrayList.addAll(this.getShellArgsList());
        }
        arrayList.addAll(this.getCommandLine(this.getOriginalExecutable(), stringArray));
        return arrayList;
    }

    public List<String> getShellArgsList() {
        return this.shellArgs;
    }

    public void addShellArg(String string) {
        this.shellArgs.add(string);
    }

    public void setQuotedArgumentsEnabled(boolean bl2) {
        this.quotedArgumentsEnabled = bl2;
    }

    public boolean isQuotedArgumentsEnabled() {
        return this.quotedArgumentsEnabled;
    }

    public void setQuotedExecutableEnabled(boolean bl2) {
        this.quotedExecutableEnabled = bl2;
    }

    public boolean isQuotedExecutableEnabled() {
        return this.quotedExecutableEnabled;
    }

    public void setExecutable(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.executable = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setWorkingDirectory(String string) {
        if (string != null) {
            this.workingDir = string;
        }
    }

    public void setWorkingDirectory(File file) {
        if (file != null) {
            this.workingDir = file.getAbsolutePath();
        }
    }

    public File getWorkingDirectory() {
        return this.workingDir == null ? null : new File(this.workingDir);
    }

    public String getWorkingDirectoryAsString() {
        return this.workingDir;
    }

    public void clearArguments() {
        this.shellArgs.clear();
    }

    public Object clone() {
        Shell shell = new Shell();
        shell.setExecutable(this.getExecutable());
        shell.setWorkingDirectory(this.getWorkingDirectory());
        shell.setShellArgs(this.getShellArgs());
        return shell;
    }

    public String getOriginalExecutable() {
        return this.executable;
    }

    public List<String> getOriginalCommandLine(String string, String[] stringArray) {
        return this.getRawCommandLine(string, stringArray);
    }

    protected void setDoubleQuotedArgumentEscaped(boolean bl2) {
        this.doubleQuotedArgumentEscaped = bl2;
    }

    protected void setDoubleQuotedExecutableEscaped(boolean bl2) {
        this.doubleQuotedExecutableEscaped = bl2;
    }

    protected void setSingleQuotedArgumentEscaped(boolean bl2) {
        this.singleQuotedArgumentEscaped = bl2;
    }

    protected void setSingleQuotedExecutableEscaped(boolean bl2) {
        this.singleQuotedExecutableEscaped = bl2;
    }
}

