/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.dag;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import zz.org.codehaus.plexus.util.dag.DAG;
import zz.org.codehaus.plexus.util.dag.Vertex;

public class CycleDetector {
    private static final Integer NOT_VISITED = 0;
    private static final Integer VISITING = 1;
    private static final Integer VISITED = 2;

    public static List<String> hasCycle(DAG dAG) {
        List<Vertex> list = dAG.getVertices();
        HashMap<Vertex, Integer> hashMap = new HashMap<Vertex, Integer>();
        List<String> list2 = null;
        for (Vertex vertex : list) {
            if (CycleDetector.isNotVisited(vertex, hashMap) && (list2 = CycleDetector.introducesCycle(vertex, hashMap)) != null) break;
        }
        return list2;
    }

    public static List<String> introducesCycle(Vertex vertex, Map<Vertex, Integer> map) {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl2 = CycleDetector.dfsVisit(vertex, linkedList, map);
        if (bl2) {
            String string = linkedList.getFirst();
            int n2 = linkedList.lastIndexOf(string);
            List<String> list = linkedList.subList(0, n2 + 1);
            Collections.reverse(list);
            return list;
        }
        return null;
    }

    public static List<String> introducesCycle(Vertex vertex) {
        HashMap<Vertex, Integer> hashMap = new HashMap<Vertex, Integer>();
        return CycleDetector.introducesCycle(vertex, hashMap);
    }

    private static boolean isNotVisited(Vertex vertex, Map<Vertex, Integer> map) {
        Integer n2 = map.get(vertex);
        return n2 == null || NOT_VISITED.equals(n2);
    }

    private static boolean isVisiting(Vertex vertex, Map<Vertex, Integer> map) {
        Integer n2 = map.get(vertex);
        return VISITING.equals(n2);
    }

    private static boolean dfsVisit(Vertex vertex, LinkedList<String> linkedList, Map<Vertex, Integer> map) {
        linkedList.addFirst(vertex.getLabel());
        map.put(vertex, VISITING);
        for (Vertex vertex2 : vertex.getChildren()) {
            if (CycleDetector.isNotVisited(vertex2, map)) {
                boolean bl2 = CycleDetector.dfsVisit(vertex2, linkedList, map);
                if (!bl2) continue;
                return true;
            }
            if (!CycleDetector.isVisiting(vertex2, map)) continue;
            linkedList.addFirst(vertex2.getLabel());
            return true;
        }
        map.put(vertex, VISITED);
        linkedList.removeFirst();
        return false;
    }
}

