/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.dag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import zz.org.codehaus.plexus.util.dag.CycleDetectedException;
import zz.org.codehaus.plexus.util.dag.CycleDetector;
import zz.org.codehaus.plexus.util.dag.TopologicalSorter;
import zz.org.codehaus.plexus.util.dag.Vertex;

public class DAG
implements Serializable,
Cloneable {
    private Map<String, Vertex> vertexMap = new HashMap<String, Vertex>();
    private List<Vertex> vertexList = new ArrayList<Vertex>();

    public List<Vertex> getVertices() {
        return this.vertexList;
    }

    @Deprecated
    public List<Vertex> getVerticies() {
        return this.getVertices();
    }

    public Set<String> getLabels() {
        return this.vertexMap.keySet();
    }

    public Vertex addVertex(String string) {
        Vertex vertex = null;
        if (this.vertexMap.containsKey(string)) {
            vertex = this.vertexMap.get(string);
        } else {
            vertex = new Vertex(string);
            this.vertexMap.put(string, vertex);
            this.vertexList.add(vertex);
        }
        return vertex;
    }

    public void addEdge(String string, String string2) throws CycleDetectedException {
        Vertex vertex = this.addVertex(string);
        Vertex vertex2 = this.addVertex(string2);
        this.addEdge(vertex, vertex2);
    }

    public void addEdge(Vertex vertex, Vertex vertex2) throws CycleDetectedException {
        vertex.addEdgeTo(vertex2);
        vertex2.addEdgeFrom(vertex);
        List<String> list = CycleDetector.introducesCycle(vertex2);
        if (list != null) {
            this.removeEdge(vertex, vertex2);
            String string = "Edge between '" + vertex + "' and '" + vertex2 + "' introduces to cycle in the graph";
            throw new CycleDetectedException(string, list);
        }
    }

    public void removeEdge(String string, String string2) {
        Vertex vertex = this.addVertex(string);
        Vertex vertex2 = this.addVertex(string2);
        this.removeEdge(vertex, vertex2);
    }

    public void removeEdge(Vertex vertex, Vertex vertex2) {
        vertex.removeEdgeTo(vertex2);
        vertex2.removeEdgeFrom(vertex);
    }

    public Vertex getVertex(String string) {
        Vertex vertex = this.vertexMap.get(string);
        return vertex;
    }

    public boolean hasEdge(String string, String string2) {
        Vertex vertex = this.getVertex(string);
        Vertex vertex2 = this.getVertex(string2);
        boolean bl2 = vertex.getChildren().contains(vertex2);
        return bl2;
    }

    public List<String> getChildLabels(String string) {
        Vertex vertex = this.getVertex(string);
        return vertex.getChildLabels();
    }

    public List<String> getParentLabels(String string) {
        Vertex vertex = this.getVertex(string);
        return vertex.getParentLabels();
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        return object;
    }

    public boolean isConnected(String string) {
        Vertex vertex = this.getVertex(string);
        boolean bl2 = vertex.isConnected();
        return bl2;
    }

    public List<String> getSuccessorLabels(String string) {
        List<String> list;
        Vertex vertex = this.getVertex(string);
        if (vertex.isLeaf()) {
            list = new ArrayList<String>(1);
            list.add(string);
        } else {
            list = TopologicalSorter.sort(vertex);
        }
        return list;
    }
}

