/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.dag;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import zz.org.codehaus.plexus.util.dag.DAG;
import zz.org.codehaus.plexus.util.dag.Vertex;

public class TopologicalSorter {
    private static final Integer NOT_VISITED = 0;
    private static final Integer VISITING = 1;
    private static final Integer VISITED = 2;

    public static List<String> sort(DAG dAG) {
        return TopologicalSorter.dfs(dAG);
    }

    public static List<String> sort(Vertex vertex) {
        LinkedList<String> linkedList = new LinkedList<String>();
        TopologicalSorter.dfsVisit(vertex, new HashMap<Vertex, Integer>(), linkedList);
        return linkedList;
    }

    private static List<String> dfs(DAG dAG) {
        LinkedList<String> linkedList = new LinkedList<String>();
        HashMap<Vertex, Integer> hashMap = new HashMap<Vertex, Integer>();
        for (Vertex vertex : dAG.getVertices()) {
            if (!TopologicalSorter.isNotVisited(vertex, hashMap)) continue;
            TopologicalSorter.dfsVisit(vertex, hashMap, linkedList);
        }
        return linkedList;
    }

    private static boolean isNotVisited(Vertex vertex, Map<Vertex, Integer> map) {
        Integer n2 = map.get(vertex);
        return n2 == null || NOT_VISITED.equals(n2);
    }

    private static void dfsVisit(Vertex vertex, Map<Vertex, Integer> map, List<String> list) {
        map.put(vertex, VISITING);
        for (Vertex vertex2 : vertex.getChildren()) {
            if (!TopologicalSorter.isNotVisited(vertex2, map)) continue;
            TopologicalSorter.dfsVisit(vertex2, map, list);
        }
        map.put(vertex, VISITED);
        list.add(vertex.getLabel());
    }
}

