/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.dag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Vertex
implements Serializable,
Cloneable {
    private String label = null;
    List<Vertex> children = new ArrayList<Vertex>();
    List<Vertex> parents = new ArrayList<Vertex>();

    public Vertex(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void addEdgeTo(Vertex vertex) {
        this.children.add(vertex);
    }

    public void removeEdgeTo(Vertex vertex) {
        this.children.remove(vertex);
    }

    public void addEdgeFrom(Vertex vertex) {
        this.parents.add(vertex);
    }

    public void removeEdgeFrom(Vertex vertex) {
        this.parents.remove(vertex);
    }

    public List<Vertex> getChildren() {
        return this.children;
    }

    public List<String> getChildLabels() {
        ArrayList<String> arrayList = new ArrayList<String>(this.children.size());
        for (Vertex vertex : this.children) {
            arrayList.add(vertex.getLabel());
        }
        return arrayList;
    }

    public List<Vertex> getParents() {
        return this.parents;
    }

    public List<String> getParentLabels() {
        ArrayList<String> arrayList = new ArrayList<String>(this.parents.size());
        for (Vertex vertex : this.parents) {
            arrayList.add(vertex.getLabel());
        }
        return arrayList;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public boolean isRoot() {
        return this.parents.size() == 0;
    }

    public boolean isConnected() {
        return this.isRoot() || this.isLeaf();
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        return object;
    }

    public String toString() {
        return "Vertex{label='" + this.label + "'" + "}";
    }
}

