/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Map;
import zz.org.codehaus.plexus.util.introspection.MethodMap;

public class ClassMap {
    private static final CacheMiss CACHE_MISS = new CacheMiss();
    private static final Object OBJECT = new Object();
    private final Class clazz;
    private Map<String, Object> methodCache = new Hashtable<String, Object>();
    private final MethodMap methodMap = new MethodMap();

    public ClassMap(Class clazz) {
        this.clazz = clazz;
        this.populateMethodCache();
    }

    Class getCachedClass() {
        return this.clazz;
    }

    public Method findMethod(String string, Object[] objectArray) throws MethodMap.AmbiguousException {
        String string2 = ClassMap.makeMethodKey(string, objectArray);
        Object object = this.methodCache.get(string2);
        if (object == CACHE_MISS) {
            return null;
        }
        if (object == null) {
            try {
                object = this.methodMap.find(string, objectArray);
            }
            catch (MethodMap.AmbiguousException ambiguousException) {
                this.methodCache.put(string2, CACHE_MISS);
                throw ambiguousException;
            }
            if (object == null) {
                this.methodCache.put(string2, CACHE_MISS);
            } else {
                this.methodCache.put(string2, object);
            }
        }
        return (Method)object;
    }

    private void populateMethodCache() {
        Method[] methodArray;
        for (Method method : methodArray = ClassMap.getAccessibleMethods(this.clazz)) {
            Method method2 = ClassMap.getPublicMethod(method);
            if (method2 == null) continue;
            this.methodMap.add(method2);
            this.methodCache.put(this.makeMethodKey(method2), method2);
        }
    }

    private String makeMethodKey(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuilder stringBuilder = new StringBuilder(method.getName());
        for (Class<?> clazz : classArray) {
            if (clazz.isPrimitive()) {
                if (clazz.equals(Boolean.TYPE)) {
                    stringBuilder.append("java.lang.Boolean");
                    continue;
                }
                if (clazz.equals(Byte.TYPE)) {
                    stringBuilder.append("java.lang.Byte");
                    continue;
                }
                if (clazz.equals(Character.TYPE)) {
                    stringBuilder.append("java.lang.Character");
                    continue;
                }
                if (clazz.equals(Double.TYPE)) {
                    stringBuilder.append("java.lang.Double");
                    continue;
                }
                if (clazz.equals(Float.TYPE)) {
                    stringBuilder.append("java.lang.Float");
                    continue;
                }
                if (clazz.equals(Integer.TYPE)) {
                    stringBuilder.append("java.lang.Integer");
                    continue;
                }
                if (clazz.equals(Long.TYPE)) {
                    stringBuilder.append("java.lang.Long");
                    continue;
                }
                if (!clazz.equals(Short.TYPE)) continue;
                stringBuilder.append("java.lang.Short");
                continue;
            }
            stringBuilder.append(clazz.getName());
        }
        return stringBuilder.toString();
    }

    private static String makeMethodKey(String string, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder().append(string);
        for (Object object : objectArray) {
            Object object2 = object;
            if (object2 == null) {
                object2 = OBJECT;
            }
            stringBuilder.append(object2.getClass().getName());
        }
        return stringBuilder.toString();
    }

    private static Method[] getAccessibleMethods(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return methodArray;
        }
        MethodInfo[] methodInfoArray = new MethodInfo[methodArray.length];
        int n2 = methodArray.length;
        while (n2-- > 0) {
            methodInfoArray[n2] = new MethodInfo(methodArray[n2]);
        }
        n2 = ClassMap.getAccessibleMethods(clazz, methodInfoArray, 0);
        if (n2 < methodArray.length) {
            methodArray = new Method[n2];
        }
        int n3 = 0;
        for (MethodInfo methodInfo : methodInfoArray) {
            if (!methodInfo.upcast) continue;
            methodArray[n3++] = methodInfo.method;
        }
        return methodArray;
    }

    private static int getAccessibleMethods(Class clazz, MethodInfo[] methodInfoArray, int n2) {
        Class clazz2;
        Object object;
        int n3 = methodInfoArray.length;
        if (Modifier.isPublic(clazz.getModifiers())) {
            for (int i2 = 0; i2 < n3 && n2 < n3; ++i2) {
                try {
                    object = methodInfoArray[i2];
                    if (((MethodInfo)object).upcast) continue;
                    ((MethodInfo)object).tryUpcasting(clazz);
                    ++n2;
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (n2 == n3) {
                return n2;
            }
        }
        if ((clazz2 = clazz.getSuperclass()) != null && (n2 = ClassMap.getAccessibleMethods(clazz2, methodInfoArray, n2)) == n3) {
            return n2;
        }
        object = clazz.getInterfaces();
        int n4 = ((Class<?>[])object).length;
        while (n4-- > 0) {
            if ((n2 = ClassMap.getAccessibleMethods(object[n4], methodInfoArray, n2)) != n3) continue;
            return n2;
        }
        return n2;
    }

    public static Method getPublicMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz.getModifiers() & 1) != 0) {
            return method;
        }
        return ClassMap.getPublicMethod(clazz, method.getName(), method.getParameterTypes());
    }

    private static Method getPublicMethod(Class clazz, String string, Class[] classArray) {
        Object object;
        if ((clazz.getModifiers() & 1) != 0) {
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (object = ClassMap.getPublicMethod(clazz2, string, classArray)) != null) {
            return object;
        }
        for (Class<?> clazz3 : object = clazz.getInterfaces()) {
            Method method = ClassMap.getPublicMethod(clazz3, string, classArray);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static final class MethodInfo {
        Method method = null;
        String name;
        Class[] parameterTypes;
        boolean upcast;

        MethodInfo(Method method) {
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            this.upcast = false;
        }

        void tryUpcasting(Class clazz) throws NoSuchMethodException {
            this.method = clazz.getMethod(this.name, this.parameterTypes);
            this.name = null;
            this.parameterTypes = null;
            this.upcast = true;
        }
    }

    private static final class CacheMiss {
        private CacheMiss() {
        }
    }
}

