/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MethodMap {
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INCOMPARABLE = 2;
    Map<String, List<Method>> methodByNameMap = new Hashtable<String, List<Method>>();

    public void add(Method method) {
        String string = method.getName();
        List<Method> list = this.get(string);
        if (list == null) {
            list = new ArrayList<Method>();
            this.methodByNameMap.put(string, list);
        }
        list.add(method);
    }

    public List<Method> get(String string) {
        return this.methodByNameMap.get(string);
    }

    public Method find(String string, Object[] objectArray) throws AmbiguousException {
        List<Method> list = this.get(string);
        if (list == null) {
            return null;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            classArray[i2] = object == null ? null : object.getClass();
        }
        return MethodMap.getMostSpecific(list, classArray);
    }

    private static Method getMostSpecific(List<Method> list, Class[] classArray) throws AmbiguousException {
        LinkedList<Method> linkedList = MethodMap.getApplicables(list, classArray);
        if (linkedList.isEmpty()) {
            return null;
        }
        if (linkedList.size() == 1) {
            return linkedList.getFirst();
        }
        LinkedList<Method> linkedList2 = new LinkedList<Method>();
        for (Method method : linkedList) {
            Class[] classArray2 = method.getParameterTypes();
            boolean bl2 = false;
            Iterator iterator = linkedList2.iterator();
            while (!bl2 && iterator.hasNext()) {
                Method method2 = (Method)iterator.next();
                switch (MethodMap.moreSpecific(classArray2, method2.getParameterTypes())) {
                    case 0: {
                        iterator.remove();
                        break;
                    }
                    case 1: {
                        bl2 = true;
                    }
                }
            }
            if (bl2) continue;
            linkedList2.addLast(method);
        }
        if (linkedList2.size() > 1) {
            throw new AmbiguousException();
        }
        return (Method)linkedList2.getFirst();
    }

    private static int moreSpecific(Class[] classArray, Class[] classArray2) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2] == classArray2[i2]) continue;
            bl2 = bl2 || MethodMap.isStrictMethodInvocationConvertible(classArray2[i2], classArray[i2]);
            bl3 = bl3 || MethodMap.isStrictMethodInvocationConvertible(classArray[i2], classArray2[i2]);
        }
        if (bl2) {
            if (bl3) {
                return 2;
            }
            return 0;
        }
        if (bl3) {
            return 1;
        }
        return 2;
    }

    private static LinkedList<Method> getApplicables(List<Method> list, Class[] classArray) {
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : list) {
            Method method2 = method;
            if (!MethodMap.isApplicable(method2, classArray)) continue;
            linkedList.add(method2);
        }
        return linkedList;
    }

    private static boolean isApplicable(Method method, Class[] classArray) {
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != classArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (MethodMap.isMethodInvocationConvertible(classArray2[i2], classArray[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean isMethodInvocationConvertible(Class clazz, Class clazz2) {
        if (clazz2 == null && !clazz.isPrimitive()) {
            return true;
        }
        if (clazz2 != null && clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE && clazz2 == Boolean.class) {
                return true;
            }
            if (clazz == Character.TYPE && clazz2 == Character.class) {
                return true;
            }
            if (clazz == Byte.TYPE && clazz2 == Byte.class) {
                return true;
            }
            if (clazz == Short.TYPE && (clazz2 == Short.class || clazz2 == Byte.class)) {
                return true;
            }
            if (clazz == Integer.TYPE && (clazz2 == Integer.class || clazz2 == Short.class || clazz2 == Byte.class)) {
                return true;
            }
            if (clazz == Long.TYPE && (clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Short.class || clazz2 == Byte.class)) {
                return true;
            }
            if (clazz == Float.TYPE && (clazz2 == Float.class || clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Short.class || clazz2 == Byte.class)) {
                return true;
            }
            if (clazz == Double.TYPE && (clazz2 == Double.class || clazz2 == Float.class || clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Short.class || clazz2 == Byte.class)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isStrictMethodInvocationConvertible(Class clazz, Class clazz2) {
        if (clazz2 == null && !clazz.isPrimitive()) {
            return true;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Short.TYPE && clazz2 == Byte.TYPE) {
                return true;
            }
            if (clazz == Integer.TYPE && (clazz2 == Short.TYPE || clazz2 == Byte.TYPE)) {
                return true;
            }
            if (clazz == Long.TYPE && (clazz2 == Integer.TYPE || clazz2 == Short.TYPE || clazz2 == Byte.TYPE)) {
                return true;
            }
            if (clazz == Float.TYPE && (clazz2 == Long.TYPE || clazz2 == Integer.TYPE || clazz2 == Short.TYPE || clazz2 == Byte.TYPE)) {
                return true;
            }
            if (clazz == Double.TYPE && (clazz2 == Float.TYPE || clazz2 == Long.TYPE || clazz2 == Integer.TYPE || clazz2 == Short.TYPE || clazz2 == Byte.TYPE)) {
                return true;
            }
        }
        return false;
    }

    public static class AmbiguousException
    extends Exception {
    }
}

