/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.introspection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import zz.org.codehaus.plexus.util.StringUtils;
import zz.org.codehaus.plexus.util.introspection.ClassMap;

public class ReflectionValueExtractor {
    private static final Class<?>[] CLASS_ARGS = new Class[0];
    private static final Object[] OBJECT_ARGS = new Object[0];
    private static final Map<Class<?>, WeakReference<ClassMap>> classMaps = new WeakHashMap();
    static final int EOF = -1;
    static final char PROPERTY_START = '.';
    static final char INDEXED_START = '[';
    static final char INDEXED_END = ']';
    static final char MAPPED_START = '(';
    static final char MAPPED_END = ')';

    private ReflectionValueExtractor() {
    }

    public static Object evaluate(String string, Object object) throws Exception {
        return ReflectionValueExtractor.evaluate(string, object, true);
    }

    public static Object evaluate(String string, Object object, boolean bl2) throws Exception {
        Tokenizer tokenizer;
        boolean bl3;
        Object object2 = object;
        if (StringUtils.isEmpty(string) || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return null;
        }
        boolean bl4 = bl3 = string.indexOf(46) >= 0;
        if (bl2 && bl3) {
            tokenizer = new Tokenizer(string);
            tokenizer.nextPropertyName();
            if (tokenizer.getPosition() == -1) {
                return null;
            }
        } else {
            tokenizer = new Tokenizer("." + string);
        }
        int n2 = tokenizer.getPosition();
        block5: while (object2 != null && tokenizer.peekChar() != -1) {
            switch (tokenizer.skipChar()) {
                case 91: {
                    object2 = ReflectionValueExtractor.getIndexedValue(string, n2, tokenizer.getPosition(), object2, tokenizer.nextToken(']'));
                    continue block5;
                }
                case 40: {
                    object2 = ReflectionValueExtractor.getMappedValue(string, n2, tokenizer.getPosition(), object2, tokenizer.nextToken(')'));
                    continue block5;
                }
                case 46: {
                    n2 = tokenizer.getPosition();
                    object2 = ReflectionValueExtractor.getPropertyValue(object2, tokenizer.nextPropertyName());
                    continue block5;
                }
            }
            return null;
        }
        return object2;
    }

    private static Object getMappedValue(String string, int n2, int n3, Object object, String string2) throws Exception {
        if (object == null || string2 == null) {
            return null;
        }
        if (object instanceof Map) {
            Object[] objectArray = new Object[]{string2};
            ClassMap classMap = ReflectionValueExtractor.getClassMap(object.getClass());
            Method method = classMap.findMethod("get", objectArray);
            return method.invoke(object, objectArray);
        }
        String string3 = String.format("The token '%s' at position '%d' refers to a java.util.Map, but the value seems is an instance of '%s'", string.subSequence(n2, n3), n2, object.getClass());
        throw new Exception(string3);
    }

    private static Object getIndexedValue(String string, int n2, int n3, Object object, String string2) throws Exception {
        try {
            int n4 = Integer.parseInt(string2);
            if (object.getClass().isArray()) {
                return Array.get(object, n4);
            }
            if (object instanceof List) {
                ClassMap classMap = ReflectionValueExtractor.getClassMap(object.getClass());
                Object[] objectArray = new Object[]{n4};
                Method method = classMap.findMethod("get", objectArray);
                return method.invoke(object, objectArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof IndexOutOfBoundsException) {
                return null;
            }
            throw invocationTargetException;
        }
        String string3 = String.format("The token '%s' at position '%d' refers to a java.util.List or an array, but the value seems is an instance of '%s'", string.subSequence(n2, n3), n2, object.getClass());
        throw new Exception(string3);
    }

    private static Object getPropertyValue(Object object, String string) throws Exception {
        if (object == null || string == null) {
            return null;
        }
        ClassMap classMap = ReflectionValueExtractor.getClassMap(object.getClass());
        String string2 = StringUtils.capitalizeFirstLetter(string);
        String string3 = "get" + string2;
        Method method = classMap.findMethod(string3, CLASS_ARGS);
        if (method == null) {
            string3 = "is" + string2;
            method = classMap.findMethod(string3, CLASS_ARGS);
        }
        if (method == null) {
            return null;
        }
        return method.invoke(object, OBJECT_ARGS);
    }

    private static ClassMap getClassMap(Class<?> clazz) {
        ClassMap classMap;
        WeakReference<ClassMap> weakReference = classMaps.get(clazz);
        if (weakReference == null || (classMap = (ClassMap)weakReference.get()) == null) {
            classMap = new ClassMap(clazz);
            classMaps.put(clazz, new WeakReference<ClassMap>(classMap));
        }
        return classMap;
    }

    static class Tokenizer {
        final String expression;
        int idx;

        public Tokenizer(String string) {
            this.expression = string;
        }

        public int peekChar() {
            return this.idx < this.expression.length() ? (int)this.expression.charAt(this.idx) : -1;
        }

        public int skipChar() {
            return this.idx < this.expression.length() ? (int)this.expression.charAt(this.idx++) : -1;
        }

        public String nextToken(char c2) {
            int n2 = this.idx;
            while (this.idx < this.expression.length() && c2 != this.expression.charAt(this.idx)) {
                ++this.idx;
            }
            if (this.idx <= n2 || this.idx >= this.expression.length()) {
                return null;
            }
            return this.expression.substring(n2, this.idx++);
        }

        public String nextPropertyName() {
            int n2 = this.idx;
            while (this.idx < this.expression.length() && Character.isJavaIdentifierPart(this.expression.charAt(this.idx))) {
                ++this.idx;
            }
            if (this.idx <= n2 || this.idx > this.expression.length()) {
                return null;
            }
            return this.expression.substring(n2, this.idx);
        }

        public int getPosition() {
            return this.idx < this.expression.length() ? this.idx : -1;
        }

        public String toString() {
            return this.idx < this.expression.length() ? this.expression.substring(this.idx) : "<EOF>";
        }
    }
}

