/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import zz.org.codehaus.plexus.util.reflection.ReflectorException;

public final class Reflector {
    private static final String CONSTRUCTOR_METHOD_NAME = "$$CONSTRUCTOR$$";
    private static final String GET_INSTANCE_METHOD_NAME = "getInstance";
    private Map<String, Map<String, Map<String, Method>>> classMaps = new HashMap<String, Map<String, Map<String, Method>>>();

    public <T> T newInstance(Class<T> clazz, Object[] objectArray) throws ReflectorException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = new Class[objectArray.length];
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        try {
            Constructor<T> constructor = this.getConstructor(clazz, classArray);
            if (constructor == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Constructor not found for class: ");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(" with specified or ancestor parameter classes: ");
                for (Class clazz2 : classArray) {
                    stringBuilder.append(clazz2.getName());
                    stringBuilder.append(',');
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                throw new ReflectorException(stringBuilder.toString());
            }
            return constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectorException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectorException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public <T> T getSingleton(Class<T> clazz, Object[] objectArray) throws ReflectorException {
        Class[] classArray = new Class[objectArray.length];
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        try {
            Method method = this.getMethod(clazz, GET_INSTANCE_METHOD_NAME, classArray);
            return (T)method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectorException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public Object invoke(Object object, String string, Object[] objectArray) throws ReflectorException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = new Class[objectArray.length];
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        try {
            Method method = this.getMethod(object.getClass(), string, classArray);
            if (method == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Singleton-producing method named '").append(string).append("' not found with specified parameter classes: ");
                for (Class clazz : classArray) {
                    stringBuilder.append(clazz.getName());
                    stringBuilder.append(',');
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                throw new ReflectorException(stringBuilder.toString());
            }
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectorException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public Object getStaticField(Class clazz, String string) throws ReflectorException {
        try {
            Field field = clazz.getField(string);
            return field.get(null);
        }
        catch (SecurityException securityException) {
            throw new ReflectorException(securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectorException(noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectorException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public Object getField(Object object, String string) throws ReflectorException {
        return this.getField(object, string, false);
    }

    public Object getField(Object object, String string, boolean bl2) throws ReflectorException {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(string);
                boolean bl3 = false;
                if (!field.isAccessible() && bl2) {
                    field.setAccessible(true);
                    bl3 = true;
                }
                Object object2 = field.get(object);
                if (bl3) {
                    field.setAccessible(false);
                }
                return object2;
            }
            catch (SecurityException securityException) {
                throw new ReflectorException(securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (clazz != Object.class) continue;
                throw new ReflectorException(noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectorException(illegalAccessException);
            }
        }
        return null;
    }

    public Object invokeStatic(Class clazz, String string, Object[] objectArray) throws ReflectorException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = new Class[objectArray.length];
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        try {
            Method method = this.getMethod(clazz, string, classArray);
            if (method == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Singleton-producing method named '").append(string).append("' not found with specified parameter classes: ");
                for (Class clazz2 : classArray) {
                    stringBuilder.append(clazz2.getName());
                    stringBuilder.append(',');
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                throw new ReflectorException(stringBuilder.toString());
            }
            return method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectorException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <T> Constructor<T> getConstructor(Class<T> clazz, Class[] classArray) throws ReflectorException {
        void var5_7;
        Map<String, Constructor<T>> map = this.getConstructorMap(clazz);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("(");
        for (Class clazz2 : classArray) {
            stringBuilder.append(clazz2.getName());
            stringBuilder.append(",");
        }
        if (classArray.length > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        String string2 = string.intern();
        synchronized (string2) {
            Constructor<T> constructor = map.get(string);
            if (constructor == null) {
                Constructor<?>[] constructorArray;
                for (Constructor<?> constructor2 : constructorArray = clazz.getConstructors()) {
                    Class<?>[] classArray2 = constructor2.getParameterTypes();
                    if (classArray.length != classArray2.length) continue;
                    int n2 = classArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (classArray2[i2].isAssignableFrom(classArray[i2])) continue;
                    }
                    Constructor<?> constructor3 = constructor2;
                    map.put(string, constructor3);
                }
            }
        }
        if (var5_7 == null) {
            throw new ReflectorException("Error retrieving constructor object for: " + clazz.getName() + string);
        }
        return var5_7;
    }

    public Object getObjectProperty(Object object, String string) throws ReflectorException {
        Object object2;
        Class[] classArray;
        Class<?> clazz;
        Method method;
        if (string == null || string.trim().length() < 1) {
            throw new ReflectorException("Cannot retrieve value for empty property.");
        }
        String string2 = "get" + Character.toUpperCase(string.charAt(0));
        if (string.trim().length() > 1) {
            string2 = string2 + string.substring(1).trim();
        }
        if ((method = this._getMethod(clazz = object.getClass(), string2, classArray = new Class[0])) == null) {
            method = this._getMethod(clazz, string, classArray);
        }
        if (method != null) {
            try {
                object2 = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectorException("Error retrieving property '" + string + "' from '" + clazz + "'", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ReflectorException("Error retrieving property '" + string + "' from '" + clazz + "'", invocationTargetException);
            }
        }
        if (method != null) {
            try {
                object2 = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectorException("Error retrieving property '" + string + "' from '" + clazz + "'", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ReflectorException("Error retrieving property '" + string + "' from '" + clazz + "'", invocationTargetException);
            }
        } else {
            object2 = this.getField(object, string, true);
            if (object2 == null) {
                throw new ReflectorException("Neither method: '" + string + "' nor bean accessor: '" + string2 + "' can be found for class: '" + clazz + "', and retrieval of field: '" + string + "' returned null as value.");
            }
        }
        return object2;
    }

    public Method getMethod(Class clazz, String string, Class[] classArray) throws ReflectorException {
        Method method = this._getMethod(clazz, string, classArray);
        if (method == null) {
            throw new ReflectorException("Method: '" + string + "' not found in class: '" + clazz + "'");
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Method _getMethod(Class clazz, String string, Class[] classArray) throws ReflectorException {
        void var6_8;
        Map<String, ?> map = this.getMethodMap(clazz, string);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("(");
        for (Class clazz2 : classArray) {
            stringBuilder.append(clazz2.getName());
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        String string2 = stringBuilder.toString();
        String string3 = string2.intern();
        synchronized (string3) {
            Method method = (Method)map.get(string2);
            if (method == null) {
                Method[] methodArray;
                for (Method method2 : methodArray = clazz.getMethods()) {
                    Class<?>[] classArray2;
                    String string4 = method2.getName();
                    if (!string.equals(string4) || classArray.length != (classArray2 = method2.getParameterTypes()).length) continue;
                    int n2 = classArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (classArray2[i2].isAssignableFrom(classArray[i2])) continue;
                    }
                    Method method3 = method2;
                    map.put(string2, method3);
                }
            }
        }
        return var6_8;
    }

    private <T> Map<String, Constructor<T>> getConstructorMap(Class<T> clazz) throws ReflectorException {
        return this.getMethodMap(clazz, CONSTRUCTOR_METHOD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ?> getMethodMap(Class clazz, String string) throws ReflectorException {
        Map<Object, Object> map;
        if (clazz == null) {
            return null;
        }
        String string2 = clazz.getName();
        String string3 = string2.intern();
        synchronized (string3) {
            Map<String, Map<String, Method>> map2 = this.classMaps.get(string2);
            if (map2 == null) {
                map2 = new HashMap<String, Map<String, Method>>();
                map = new HashMap();
                map2.put(string, map);
                this.classMaps.put(string2, map2);
            } else {
                String string4 = string2 + "::" + string;
                String string5 = string4.intern();
                synchronized (string5) {
                    map = map2.get(string);
                    if (map == null) {
                        map = new HashMap();
                        map2.put(string, map);
                    }
                }
            }
        }
        return map;
    }
}

