/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.xml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.org.codehaus.plexus.util.StringUtils;
import zz.org.codehaus.plexus.util.xml.XMLWriter;

public class PrettyPrintXMLWriter
implements XMLWriter {
    protected static final String LS = System.getProperty("line.separator");
    private PrintWriter writer;
    private LinkedList<String> elementStack = new LinkedList();
    private boolean tagInProgress;
    private int depth;
    private String lineIndenter;
    private String lineSeparator;
    private String encoding;
    private String docType;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;
    private static final Pattern amp = Pattern.compile("&");
    private static final Pattern lt = Pattern.compile("<");
    private static final Pattern gt = Pattern.compile(">");
    private static final Pattern dqoute = Pattern.compile("\"");
    private static final Pattern sqoute = Pattern.compile("'");
    private static final String crlf_str = "\r\n";
    private static final Pattern crlf = Pattern.compile("\r\n");
    private static final Pattern lowers = Pattern.compile("([\u0000-\u001f])");

    public PrettyPrintXMLWriter(PrintWriter printWriter, String string) {
        this(printWriter, string, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer, String string) {
        this(new PrintWriter(writer), string);
    }

    public PrettyPrintXMLWriter(PrintWriter printWriter) {
        this(printWriter, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public PrettyPrintXMLWriter(PrintWriter printWriter, String string, String string2, String string3) {
        this(printWriter, string, LS, string2, string3);
    }

    public PrettyPrintXMLWriter(Writer writer, String string, String string2, String string3) {
        this(new PrintWriter(writer), string, string2, string3);
    }

    public PrettyPrintXMLWriter(PrintWriter printWriter, String string, String string2) {
        this(printWriter, "  ", string, string2);
    }

    public PrettyPrintXMLWriter(Writer writer, String string, String string2) {
        this(new PrintWriter(writer), string, string2);
    }

    public PrettyPrintXMLWriter(PrintWriter printWriter, String string, String string2, String string3, String string4) {
        this.setWriter(printWriter);
        this.setLineIndenter(string);
        this.setLineSeparator(string2);
        this.setEncoding(string3);
        this.setDocType(string4);
        if (string4 != null || string3 != null) {
            this.writeDocumentHeaders();
        }
    }

    @Override
    public void startElement(String string) {
        this.tagIsEmpty = false;
        this.finishTag();
        this.write("<");
        this.write(string);
        this.elementStack.addLast(string);
        this.tagInProgress = true;
        this.setDepth(this.getDepth() + 1);
        this.readyForNewLine = true;
        this.tagIsEmpty = true;
    }

    @Override
    public void writeText(String string) {
        this.writeText(string, true);
    }

    @Override
    public void writeMarkup(String string) {
        this.writeText(string, false);
    }

    private void writeText(String string, boolean bl2) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        if (bl2) {
            string = PrettyPrintXMLWriter.escapeXml(string);
        }
        this.write(StringUtils.unifyLineSeparators(string, this.lineSeparator));
    }

    private static String escapeXml(String string) {
        if (string.indexOf(38) >= 0) {
            string = amp.matcher(string).replaceAll("&amp;");
        }
        if (string.indexOf(60) >= 0) {
            string = lt.matcher(string).replaceAll("&lt;");
        }
        if (string.indexOf(62) >= 0) {
            string = gt.matcher(string).replaceAll("&gt;");
        }
        if (string.indexOf(34) >= 0) {
            string = dqoute.matcher(string).replaceAll("&quot;");
        }
        if (string.indexOf(39) >= 0) {
            string = sqoute.matcher(string).replaceAll("&apos;");
        }
        return string;
    }

    private static String escapeXmlAttribute(String string) {
        string = PrettyPrintXMLWriter.escapeXml(string);
        Matcher matcher = crlf.matcher(string);
        if (string.contains(crlf_str)) {
            string = matcher.replaceAll("&#10;");
        }
        Matcher matcher2 = lowers.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher2.find()) {
            matcher2 = matcher2.appendReplacement(stringBuffer, "&#" + Integer.toString(matcher2.group(1).charAt(0)) + ";");
        }
        matcher2.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public void addAttribute(String string, String string2) {
        this.write(" ");
        this.write(string);
        this.write("=\"");
        this.write(PrettyPrintXMLWriter.escapeXmlAttribute(string2));
        this.write("\"");
    }

    @Override
    public void endElement() {
        this.setDepth(this.getDepth() - 1);
        if (this.tagIsEmpty) {
            this.write("/");
            this.readyForNewLine = false;
            this.finishTag();
            this.elementStack.removeLast();
        } else {
            this.finishTag();
            this.write("</" + this.elementStack.removeLast() + ">");
        }
        this.readyForNewLine = true;
    }

    private void write(String string) {
        this.getWriter().write(string);
    }

    private void finishTag() {
        if (this.tagInProgress) {
            this.write(">");
        }
        this.tagInProgress = false;
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    protected String getLineIndenter() {
        return this.lineIndenter;
    }

    protected void setLineIndenter(String string) {
        this.lineIndenter = string;
    }

    protected String getLineSeparator() {
        return this.lineSeparator;
    }

    protected void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    protected void endOfLine() {
        this.write(this.getLineSeparator());
        for (int i2 = 0; i2 < this.getDepth(); ++i2) {
            this.write(this.getLineIndenter());
        }
    }

    private void writeDocumentHeaders() {
        this.write("<?xml version=\"1.0\"");
        if (this.getEncoding() != null) {
            this.write(" encoding=\"" + this.getEncoding() + "\"");
        }
        this.write("?>");
        this.endOfLine();
        if (this.getDocType() != null) {
            this.write("<!DOCTYPE ");
            this.write(this.getDocType());
            this.write(">");
            this.endOfLine();
        }
    }

    protected void setWriter(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("writer could not be null");
        }
        this.writer = printWriter;
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected void setDepth(int n2) {
        this.depth = n2;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected void setEncoding(String string) {
        this.encoding = string;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected void setDocType(String string) {
        this.docType = string;
    }

    protected String getDocType() {
        return this.docType;
    }

    protected LinkedList<String> getElementStack() {
        return this.elementStack;
    }
}

