/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import zz.org.codehaus.plexus.util.xml.XMLWriter;
import zz.org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class SerializerXMLWriter
implements XMLWriter {
    private final XmlSerializer serializer;
    private final String namespace;
    private final Stack<String> elements = new Stack();
    private List<Exception> exceptions;

    public SerializerXMLWriter(String string, XmlSerializer xmlSerializer) {
        this.serializer = xmlSerializer;
        this.namespace = string;
    }

    @Override
    public void startElement(String string) {
        try {
            this.serializer.startTag(this.namespace, string);
            this.elements.push(string);
        }
        catch (IOException iOException) {
            this.storeException(iOException);
        }
    }

    @Override
    public void addAttribute(String string, String string2) {
        try {
            this.serializer.attribute(this.namespace, string, string2);
        }
        catch (IOException iOException) {
            this.storeException(iOException);
        }
    }

    @Override
    public void writeText(String string) {
        try {
            this.serializer.text(string);
        }
        catch (IOException iOException) {
            this.storeException(iOException);
        }
    }

    @Override
    public void writeMarkup(String string) {
        try {
            this.serializer.cdsect(string);
        }
        catch (IOException iOException) {
            this.storeException(iOException);
        }
    }

    @Override
    public void endElement() {
        try {
            this.serializer.endTag(this.namespace, this.elements.pop());
        }
        catch (IOException iOException) {
            this.storeException(iOException);
        }
    }

    private void storeException(IOException iOException) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<Exception>();
        }
        this.exceptions.add(iOException);
    }

    public List<Exception> getExceptions() {
        return this.exceptions == null ? Collections.emptyList() : this.exceptions;
    }
}

