/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.org.codehaus.plexus.util.xml.XmlStreamReaderException;

public class XmlReader
extends Reader {
    private static final int BUFFER_SIZE = 4096;
    private static final String UTF_8 = "UTF-8";
    private static final String US_ASCII = "US-ASCII";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_16 = "UTF-16";
    private static final String EBCDIC = "CP1047";
    private static String _staticDefaultEncoding = null;
    private Reader _reader;
    private String _encoding;
    private String _defaultEncoding;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([.[^; ]]*)");
    static final Pattern ENCODING_PATTERN = Pattern.compile("<\\?xml.*encoding[\\s]*=[\\s]*((?:\".[^\"]*\")|(?:'.[^']*'))", 8);
    private static final MessageFormat RAW_EX_1 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch");
    private static final MessageFormat RAW_EX_2 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM");
    private static final MessageFormat HTTP_EX_1 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be NULL");
    private static final MessageFormat HTTP_EX_2 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch");
    private static final MessageFormat HTTP_EX_3 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Invalid MIME");

    public static void setDefaultEncoding(String string) {
        _staticDefaultEncoding = string;
    }

    public static String getDefaultEncoding() {
        return _staticDefaultEncoding;
    }

    public XmlReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public XmlReader(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public XmlReader(InputStream inputStream, boolean bl2) throws IOException, XmlStreamReaderException {
        this._defaultEncoding = _staticDefaultEncoding;
        try {
            this.doRawStream(inputStream, bl2);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (!bl2) {
                throw xmlStreamReaderException;
            }
            this.doLenientDetection(null, xmlStreamReaderException);
        }
    }

    public XmlReader(URL uRL) throws IOException {
        this(uRL.openConnection());
    }

    public XmlReader(URLConnection uRLConnection) throws IOException {
        this._defaultEncoding = _staticDefaultEncoding;
        boolean bl2 = true;
        if (uRLConnection instanceof HttpURLConnection) {
            try {
                this.doHttpStream(uRLConnection.getInputStream(), uRLConnection.getContentType(), bl2);
            }
            catch (XmlStreamReaderException xmlStreamReaderException) {
                this.doLenientDetection(uRLConnection.getContentType(), xmlStreamReaderException);
            }
        } else if (uRLConnection.getContentType() != null) {
            try {
                this.doHttpStream(uRLConnection.getInputStream(), uRLConnection.getContentType(), bl2);
            }
            catch (XmlStreamReaderException xmlStreamReaderException) {
                this.doLenientDetection(uRLConnection.getContentType(), xmlStreamReaderException);
            }
        } else {
            try {
                this.doRawStream(uRLConnection.getInputStream(), bl2);
            }
            catch (XmlStreamReaderException xmlStreamReaderException) {
                this.doLenientDetection(null, xmlStreamReaderException);
            }
        }
    }

    public XmlReader(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, true);
    }

    public XmlReader(InputStream inputStream, String string, boolean bl2, String string2) throws IOException, XmlStreamReaderException {
        this._defaultEncoding = string2 == null ? _staticDefaultEncoding : string2;
        try {
            this.doHttpStream(inputStream, string, bl2);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (!bl2) {
                throw xmlStreamReaderException;
            }
            this.doLenientDetection(string, xmlStreamReaderException);
        }
    }

    public XmlReader(InputStream inputStream, String string, boolean bl2) throws IOException, XmlStreamReaderException {
        this(inputStream, string, bl2, null);
    }

    private void doLenientDetection(String string, XmlStreamReaderException xmlStreamReaderException) throws IOException {
        if (string != null && string.startsWith("text/html")) {
            string = string.substring("text/html".length());
            string = "text/xml" + string;
            try {
                this.doHttpStream(xmlStreamReaderException.getInputStream(), string, true);
                xmlStreamReaderException = null;
            }
            catch (XmlStreamReaderException xmlStreamReaderException2) {
                xmlStreamReaderException = xmlStreamReaderException2;
            }
        }
        if (xmlStreamReaderException != null) {
            String string2 = xmlStreamReaderException.getXmlEncoding();
            if (string2 == null) {
                string2 = xmlStreamReaderException.getContentTypeEncoding();
            }
            if (string2 == null) {
                string2 = this._defaultEncoding == null ? UTF_8 : this._defaultEncoding;
            }
            this.prepareReader(xmlStreamReaderException.getInputStream(), string2);
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        return this._reader.read(cArray, n2, n3);
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
    }

    private void doRawStream(InputStream inputStream, boolean bl2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        String string = XmlReader.getBOMEncoding(bufferedInputStream);
        String string2 = XmlReader.getXMLGuessEncoding(bufferedInputStream);
        String string3 = XmlReader.getXmlProlog(bufferedInputStream, string2);
        String string4 = this.calculateRawEncoding(string, string2, string3, bufferedInputStream);
        this.prepareReader(bufferedInputStream, string4);
    }

    private void doHttpStream(InputStream inputStream, String string, boolean bl2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        String string2 = XmlReader.getContentTypeMime(string);
        String string3 = XmlReader.getContentTypeEncoding(string);
        String string4 = XmlReader.getBOMEncoding(bufferedInputStream);
        String string5 = XmlReader.getXMLGuessEncoding(bufferedInputStream);
        String string6 = XmlReader.getXmlProlog(bufferedInputStream, string5);
        String string7 = this.calculateHttpEncoding(string2, string3, string4, string5, string6, bufferedInputStream, bl2);
        this.prepareReader(bufferedInputStream, string7);
    }

    private void prepareReader(InputStream inputStream, String string) throws IOException {
        this._reader = new InputStreamReader(inputStream, string);
        this._encoding = string;
    }

    private String calculateRawEncoding(String string, String string2, String string3, InputStream inputStream) throws IOException {
        String string4;
        if (string == null) {
            string4 = string2 == null || string3 == null ? (this._defaultEncoding == null ? UTF_8 : this._defaultEncoding) : (string3.equals(UTF_16) && (string2.equals(UTF_16BE) || string2.equals(UTF_16LE)) ? string2 : string3);
        } else if (string.equals(UTF_8)) {
            if (string2 != null && !string2.equals(UTF_8)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{string, string2, string3}), string, string2, string3, inputStream);
            }
            if (string3 != null && !string3.equals(UTF_8)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{string, string2, string3}), string, string2, string3, inputStream);
            }
            string4 = UTF_8;
        } else if (string.equals(UTF_16BE) || string.equals(UTF_16LE)) {
            if (string2 != null && !string2.equals(string)) {
                throw new IOException(RAW_EX_1.format(new Object[]{string, string2, string3}));
            }
            if (string3 != null && !string3.equals(UTF_16) && !string3.equals(string)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{string, string2, string3}), string, string2, string3, inputStream);
            }
            string4 = string;
        } else {
            throw new XmlStreamReaderException(RAW_EX_2.format(new Object[]{string, string2, string3}), string, string2, string3, inputStream);
        }
        return string4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String calculateHttpEncoding(String string, String string2, String string3, String string4, String string5, InputStream inputStream, boolean bl2) throws IOException {
        if (bl2 & string5 != null) {
            return string5;
        }
        boolean bl3 = XmlReader.isAppXml(string);
        boolean bl4 = XmlReader.isTextXml(string);
        if (!bl3 && !bl4) throw new XmlStreamReaderException(HTTP_EX_3.format(new Object[]{string, string2, string3, string4, string5}), string, string2, string3, string4, string5, inputStream);
        if (string2 == null) {
            if (bl3) {
                return this.calculateRawEncoding(string3, string4, string5, inputStream);
            }
            if (this._defaultEncoding == null) {
                return US_ASCII;
            }
            String string6 = this._defaultEncoding;
            return string6;
        }
        if (string3 != null && (string2.equals(UTF_16BE) || string2.equals(UTF_16LE))) {
            throw new XmlStreamReaderException(HTTP_EX_1.format(new Object[]{string, string2, string3, string4, string5}), string, string2, string3, string4, string5, inputStream);
        }
        if (!string2.equals(UTF_16)) return string2;
        if (string3 == null || !string3.startsWith(UTF_16)) throw new XmlStreamReaderException(HTTP_EX_2.format(new Object[]{string, string2, string3, string4, string5}), string, string2, string3, string4, string5, inputStream);
        return string3;
    }

    private static String getContentTypeMime(String string) {
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf(";");
            string2 = (n2 == -1 ? string : string.substring(0, n2)).trim();
        }
        return string2;
    }

    private static String getContentTypeEncoding(String string) {
        int n2;
        String string2 = null;
        if (string != null && (n2 = string.indexOf(";")) > -1) {
            String string3 = string.substring(n2 + 1);
            Matcher matcher = CHARSET_PATTERN.matcher(string3);
            string2 = matcher.find() ? matcher.group(1) : null;
            string2 = string2 != null ? string2.toUpperCase(Locale.ENGLISH) : null;
        }
        return string2;
    }

    private static String getBOMEncoding(BufferedInputStream bufferedInputStream) throws IOException {
        String string = null;
        int[] nArray = new int[3];
        bufferedInputStream.mark(3);
        nArray[0] = bufferedInputStream.read();
        nArray[1] = bufferedInputStream.read();
        nArray[2] = bufferedInputStream.read();
        if (nArray[0] == 254 && nArray[1] == 255) {
            string = UTF_16BE;
            bufferedInputStream.reset();
            bufferedInputStream.read();
            bufferedInputStream.read();
        } else if (nArray[0] == 255 && nArray[1] == 254) {
            string = UTF_16LE;
            bufferedInputStream.reset();
            bufferedInputStream.read();
            bufferedInputStream.read();
        } else if (nArray[0] == 239 && nArray[1] == 187 && nArray[2] == 191) {
            string = UTF_8;
        } else {
            bufferedInputStream.reset();
        }
        return string;
    }

    private static String getXMLGuessEncoding(BufferedInputStream bufferedInputStream) throws IOException {
        String string = null;
        int[] nArray = new int[4];
        bufferedInputStream.mark(4);
        nArray[0] = bufferedInputStream.read();
        nArray[1] = bufferedInputStream.read();
        nArray[2] = bufferedInputStream.read();
        nArray[3] = bufferedInputStream.read();
        bufferedInputStream.reset();
        if (nArray[0] == 0 && nArray[1] == 60 && nArray[2] == 0 && nArray[3] == 63) {
            string = UTF_16BE;
        } else if (nArray[0] == 60 && nArray[1] == 0 && nArray[2] == 63 && nArray[3] == 0) {
            string = UTF_16LE;
        } else if (nArray[0] == 60 && nArray[1] == 63 && nArray[2] == 120 && nArray[3] == 109) {
            string = UTF_8;
        } else if (nArray[0] == 76 && nArray[1] == 111 && nArray[2] == 167 && nArray[3] == 148) {
            string = EBCDIC;
        }
        return string;
    }

    private static String getXmlProlog(BufferedInputStream bufferedInputStream, String string) throws IOException {
        String string2 = null;
        if (string != null) {
            byte[] byArray = new byte[4096];
            bufferedInputStream.mark(4096);
            int n2 = 0;
            int n3 = 4096;
            int n4 = bufferedInputStream.read(byArray, n2, n3);
            int n5 = -1;
            String string3 = null;
            while (n4 != -1 && n5 == -1 && n2 < 4096) {
                n4 = bufferedInputStream.read(byArray, n2 += n4, n3 -= n4);
                string3 = new String(byArray, 0, n2, string);
                n5 = string3.indexOf(62);
            }
            if (n5 == -1) {
                if (n4 == -1) {
                    throw new IOException("Unexpected end of XML stream");
                }
                throw new IOException("XML prolog or ROOT element not found on first " + n2 + " bytes");
            }
            int n6 = n2;
            if (n6 > 0) {
                bufferedInputStream.reset();
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string3.substring(0, n5 + 1)));
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    stringBuilder.append(string4);
                    string4 = bufferedReader.readLine();
                }
                Matcher matcher = ENCODING_PATTERN.matcher(stringBuilder);
                if (matcher.find()) {
                    string2 = matcher.group(1).toUpperCase(Locale.ENGLISH);
                    string2 = string2.substring(1, string2.length() - 1);
                }
            }
        }
        return string2;
    }

    private static boolean isAppXml(String string) {
        return string != null && (string.equals("application/xml") || string.equals("application/xml-dtd") || string.equals("application/xml-external-parsed-entity") || string.startsWith("application/") && string.endsWith("+xml"));
    }

    private static boolean isTextXml(String string) {
        return string != null && (string.equals("text/xml") || string.equals("text/xml-external-parsed-entity") || string.startsWith("text/") && string.endsWith("+xml"));
    }
}

