/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.org.codehaus.plexus.util.xml.XmlReader;

public class XmlStreamWriter
extends Writer {
    private static final int BUFFER_SIZE = 4096;
    private StringWriter xmlPrologWriter = new StringWriter(4096);
    private OutputStream out;
    private Writer writer;
    private String encoding;
    static final Pattern ENCODING_PATTERN = XmlReader.ENCODING_PATTERN;

    public XmlStreamWriter(OutputStream outputStream) {
        this.out = outputStream;
    }

    public XmlStreamWriter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() throws IOException {
        if (this.writer == null) {
            this.encoding = "UTF-8";
            this.writer = new OutputStreamWriter(this.out, this.encoding);
            this.writer.write(this.xmlPrologWriter.toString());
        }
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    private void detectEncoding(char[] cArray, int n2, int n3) throws IOException {
        int n4 = n3;
        StringBuffer stringBuffer = this.xmlPrologWriter.getBuffer();
        if (stringBuffer.length() + n3 > 4096) {
            n4 = 4096 - stringBuffer.length();
        }
        this.xmlPrologWriter.write(cArray, n2, n4);
        if (stringBuffer.length() >= 5) {
            if (stringBuffer.substring(0, 5).equals("<?xml")) {
                int n5 = stringBuffer.indexOf("?>");
                if (n5 > 0) {
                    Matcher matcher = ENCODING_PATTERN.matcher(stringBuffer.substring(0, n5));
                    if (matcher.find()) {
                        this.encoding = matcher.group(1).toUpperCase(Locale.ENGLISH);
                        this.encoding = this.encoding.substring(1, this.encoding.length() - 1);
                    } else {
                        this.encoding = "UTF-8";
                    }
                } else if (stringBuffer.length() >= 4096) {
                    this.encoding = "UTF-8";
                }
            } else {
                this.encoding = "UTF-8";
            }
            if (this.encoding != null) {
                this.xmlPrologWriter = null;
                this.writer = new OutputStreamWriter(this.out, this.encoding);
                this.writer.write(stringBuffer.toString());
                if (n3 > n4) {
                    this.writer.write(cArray, n2 + n4, n3 - n4);
                }
            }
        }
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.xmlPrologWriter != null) {
            this.detectEncoding(cArray, n2, n3);
        } else {
            this.writer.write(cArray, n2, n3);
        }
    }
}

