/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util.xml.pull;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import zz.org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class MXSerializer
implements XmlSerializer {
    protected static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    protected static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final boolean TRACE_SIZING = false;
    protected final String FEATURE_SERIALIZER_ATTVALUE_USE_APOSTROPHE = "http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe";
    protected final String FEATURE_NAMES_INTERNED = "http://xmlpull.org/v1/doc/features.html#names-interned";
    protected final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    protected final String PROPERTY_SERIALIZER_LINE_SEPARATOR = "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator";
    protected static final String PROPERTY_LOCATION = "http://xmlpull.org/v1/doc/properties.html#location";
    protected boolean namesInterned;
    protected boolean attributeUseApostrophe;
    protected String indentationString = null;
    protected String lineSeparator = "\n";
    protected String location;
    protected Writer out;
    protected int autoDeclaredPrefixes;
    protected int depth = 0;
    protected String[] elNamespace = new String[2];
    protected String[] elName = new String[this.elNamespace.length];
    protected int[] elNamespaceCount = new int[this.elNamespace.length];
    protected int namespaceEnd = 0;
    protected String[] namespacePrefix = new String[8];
    protected String[] namespaceUri = new String[this.namespacePrefix.length];
    protected boolean finished;
    protected boolean pastRoot;
    protected boolean setPrefixCalled;
    protected boolean startTagIncomplete;
    protected boolean doIndent;
    protected boolean seenTag;
    protected boolean seenBracket;
    protected boolean seenBracketBracket;
    private static final int BUF_LEN = Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 256;
    protected char[] buf = new char[BUF_LEN];
    protected static final String[] precomputedPrefixes = new String[32];
    private boolean checkNamesInterned = false;
    protected int offsetNewLine;
    protected int indentationJump;
    protected char[] indentationBuf;
    protected int maxIndentLevel;
    protected boolean writeLineSeparator;
    protected boolean writeIndentation;

    private void checkInterning(String string) {
        if (this.namesInterned && string != string.intern()) {
            throw new IllegalArgumentException("all names passed as arguments must be internedwhen NAMES INTERNED feature is enabled");
        }
    }

    protected void reset() {
        this.location = null;
        this.out = null;
        this.autoDeclaredPrefixes = 0;
        this.depth = 0;
        for (int i2 = 0; i2 < this.elNamespaceCount.length; ++i2) {
            this.elName[i2] = null;
            this.elNamespace[i2] = null;
            this.elNamespaceCount[i2] = 2;
        }
        this.namespaceEnd = 0;
        this.namespacePrefix[this.namespaceEnd] = "xmlns";
        this.namespaceUri[this.namespaceEnd] = XMLNS_URI;
        ++this.namespaceEnd;
        this.namespacePrefix[this.namespaceEnd] = "xml";
        this.namespaceUri[this.namespaceEnd] = XML_URI;
        ++this.namespaceEnd;
        this.finished = false;
        this.pastRoot = false;
        this.setPrefixCalled = false;
        this.startTagIncomplete = false;
        this.seenTag = false;
        this.seenBracket = false;
        this.seenBracketBracket = false;
    }

    protected void ensureElementsCapacity() {
        int n2 = this.elName.length;
        int n3 = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
        boolean bl2 = n2 > 0;
        String[] stringArray = null;
        stringArray = new String[n3];
        if (bl2) {
            System.arraycopy(this.elName, 0, stringArray, 0, n2);
        }
        this.elName = stringArray;
        stringArray = new String[n3];
        if (bl2) {
            System.arraycopy(this.elNamespace, 0, stringArray, 0, n2);
        }
        this.elNamespace = stringArray;
        int[] nArray = new int[n3];
        if (bl2) {
            System.arraycopy(this.elNamespaceCount, 0, nArray, 0, n2);
        } else {
            nArray[0] = 0;
        }
        this.elNamespaceCount = nArray;
    }

    protected void ensureNamespacesCapacity() {
        int n2 = this.namespaceEnd > 7 ? 2 * this.namespaceEnd : 8;
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        if (this.namespacePrefix != null) {
            System.arraycopy(this.namespacePrefix, 0, stringArray, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceUri, 0, stringArray2, 0, this.namespaceEnd);
        }
        this.namespacePrefix = stringArray;
        this.namespaceUri = stringArray2;
    }

    @Override
    public void setFeature(String string, boolean bl2) throws IllegalArgumentException, IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(string)) {
            this.namesInterned = bl2;
        } else if ("http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe".equals(string)) {
            this.attributeUseApostrophe = bl2;
        } else {
            throw new IllegalStateException("unsupported feature " + string);
        }
    }

    @Override
    public boolean getFeature(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(string)) {
            return this.namesInterned;
        }
        if ("http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe".equals(string)) {
            return this.attributeUseApostrophe;
        }
        return false;
    }

    protected void rebuildIndentationBuf() {
        int n2;
        if (!this.doIndent) {
            return;
        }
        int n3 = 65;
        int n4 = 0;
        this.offsetNewLine = 0;
        if (this.writeLineSeparator) {
            this.offsetNewLine = this.lineSeparator.length();
            n4 += this.offsetNewLine;
        }
        this.maxIndentLevel = 0;
        if (this.writeIndentation) {
            this.indentationJump = this.indentationString.length();
            this.maxIndentLevel = 65 / this.indentationJump;
            n4 += this.maxIndentLevel * this.indentationJump;
        }
        if (this.indentationBuf == null || this.indentationBuf.length < n4) {
            this.indentationBuf = new char[n4 + 8];
        }
        int n5 = 0;
        if (this.writeLineSeparator) {
            for (n2 = 0; n2 < this.lineSeparator.length(); ++n2) {
                this.indentationBuf[n5++] = this.lineSeparator.charAt(n2);
            }
        }
        if (this.writeIndentation) {
            for (n2 = 0; n2 < this.maxIndentLevel; ++n2) {
                for (int i2 = 0; i2 < this.indentationString.length(); ++i2) {
                    this.indentationBuf[n5++] = this.indentationString.charAt(i2);
                }
            }
        }
    }

    protected void writeIndent() throws IOException {
        int n2 = this.writeLineSeparator ? 0 : this.offsetNewLine;
        int n3 = this.depth > this.maxIndentLevel ? this.maxIndentLevel : this.depth;
        this.out.write(this.indentationBuf, n2, n3 * this.indentationJump + this.offsetNewLine);
    }

    @Override
    public void setProperty(String string, Object object) throws IllegalArgumentException, IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-indentation".equals(string)) {
            this.indentationString = (String)object;
        } else if ("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator".equals(string)) {
            this.lineSeparator = (String)object;
        } else if (PROPERTY_LOCATION.equals(string)) {
            this.location = (String)object;
        } else {
            throw new IllegalStateException("unsupported property " + string);
        }
        this.writeLineSeparator = this.lineSeparator != null && this.lineSeparator.length() > 0;
        this.writeIndentation = this.indentationString != null && this.indentationString.length() > 0;
        this.doIndent = this.indentationString != null && (this.writeLineSeparator || this.writeIndentation);
        this.rebuildIndentationBuf();
        this.seenTag = false;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-indentation".equals(string)) {
            return this.indentationString;
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator".equals(string)) {
            return this.lineSeparator;
        }
        if (PROPERTY_LOCATION.equals(string)) {
            return this.location;
        }
        return null;
    }

    private String getLocation() {
        return this.location != null ? " @" + this.location : "";
    }

    public Writer getWriter() {
        return this.out;
    }

    @Override
    public void setOutput(Writer writer) {
        this.reset();
        this.out = writer;
    }

    @Override
    public void setOutput(OutputStream outputStream, String string) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("output stream can not be null");
        }
        this.reset();
        this.out = string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream);
    }

    @Override
    public void startDocument(String string, Boolean bl2) throws IOException {
        int n2;
        int n3 = n2 = this.attributeUseApostrophe ? 39 : 34;
        if (this.attributeUseApostrophe) {
            this.out.write("<?xml version='1.0'");
        } else {
            this.out.write("<?xml version=\"1.0\"");
        }
        if (string != null) {
            this.out.write(" encoding=");
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            this.out.write(string);
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
        }
        if (bl2 != null) {
            this.out.write(" standalone=");
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            if (bl2.booleanValue()) {
                this.out.write("yes");
            } else {
                this.out.write("no");
            }
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
        }
        this.out.write("?>");
        if (this.writeLineSeparator) {
            this.out.write(this.lineSeparator);
        }
    }

    @Override
    public void endDocument() throws IOException {
        while (this.depth > 0) {
            this.endTag(this.elNamespace[this.depth], this.elName[this.depth]);
        }
        if (this.writeLineSeparator) {
            this.out.write(this.lineSeparator);
        }
        this.startTagIncomplete = true;
        this.pastRoot = true;
        this.finished = true;
        this.out.flush();
    }

    @Override
    public void setPrefix(String string, String string2) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        if (string == null) {
            string = "";
        }
        if (!this.namesInterned) {
            string = string.intern();
        } else if (this.checkNamesInterned) {
            this.checkInterning(string);
        } else if (string == null) {
            throw new IllegalArgumentException("prefix must be not null" + this.getLocation());
        }
        for (int i2 = this.elNamespaceCount[this.depth]; i2 < this.namespaceEnd; ++i2) {
            if (string != this.namespacePrefix[i2]) continue;
            throw new IllegalStateException("duplicated prefix " + MXSerializer.printable(string) + this.getLocation());
        }
        if (!this.namesInterned) {
            string2 = string2.intern();
        } else if (this.checkNamesInterned) {
            this.checkInterning(string2);
        } else if (string2 == null) {
            throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string;
        this.namespaceUri[this.namespaceEnd] = string2;
        ++this.namespaceEnd;
        this.setPrefixCalled = true;
    }

    protected String lookupOrDeclarePrefix(String string) {
        return this.getPrefix(string, true);
    }

    @Override
    public String getPrefix(String string, boolean bl2) {
        if (!this.namesInterned) {
            string = string.intern();
        } else if (this.checkNamesInterned) {
            this.checkInterning(string);
        }
        if (string == null) {
            throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("default namespace cannot have prefix" + this.getLocation());
        }
        for (int i2 = this.namespaceEnd - 1; i2 >= 0; --i2) {
            if (string != this.namespaceUri[i2]) continue;
            String string2 = this.namespacePrefix[i2];
            for (int i3 = this.namespaceEnd - 1; i3 > i2; --i3) {
                if (string2 != this.namespacePrefix[i3]) continue;
            }
            return string2;
        }
        if (!bl2) {
            return null;
        }
        return this.generatePrefix(string);
    }

    private String generatePrefix(String string) {
        ++this.autoDeclaredPrefixes;
        String string2 = this.autoDeclaredPrefixes < precomputedPrefixes.length ? precomputedPrefixes[this.autoDeclaredPrefixes] : ("n" + this.autoDeclaredPrefixes).intern();
        for (int i2 = this.namespaceEnd - 1; i2 >= 0; --i2) {
            if (string2 != this.namespacePrefix[i2]) continue;
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string2;
        this.namespaceUri[this.namespaceEnd] = string;
        ++this.namespaceEnd;
        return string2;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getNamespace() {
        return this.elNamespace[this.depth];
    }

    @Override
    public String getName() {
        return this.elName[this.depth];
    }

    @Override
    public XmlSerializer startTag(String string, String string2) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.seenBracketBracket = false;
        this.seenBracket = false;
        if (this.doIndent && this.depth > 0 && this.seenTag) {
            this.writeIndent();
        }
        this.seenTag = true;
        this.setPrefixCalled = false;
        this.startTagIncomplete = true;
        ++this.depth;
        if (this.depth + 1 >= this.elName.length) {
            this.ensureElementsCapacity();
        }
        if (this.checkNamesInterned && this.namesInterned) {
            this.checkInterning(string);
        }
        String string3 = this.elNamespace[this.depth] = this.namesInterned || string == null ? string : string.intern();
        if (this.checkNamesInterned && this.namesInterned) {
            this.checkInterning(string2);
        }
        String string4 = this.elName[this.depth] = this.namesInterned || string2 == null ? string2 : string2.intern();
        if (this.out == null) {
            throw new IllegalStateException("setOutput() must called set before serialization can start");
        }
        this.out.write(60);
        if (string != null) {
            if (string.length() > 0) {
                String string5;
                String string6 = null;
                if (this.depth > 0 && this.namespaceEnd - this.elNamespaceCount[this.depth - 1] == 1 && ((string5 = this.namespaceUri[this.namespaceEnd - 1]) == string || string5.equals(string))) {
                    String string7 = this.namespacePrefix[this.namespaceEnd - 1];
                    for (int i2 = this.elNamespaceCount[this.depth - 1] - 1; i2 >= 2; --i2) {
                        String string8 = this.namespacePrefix[i2];
                        if (string8 != string7 && !string8.equals(string7)) continue;
                        String string9 = this.namespaceUri[i2];
                        if (string9 != string5 && !string9.equals(string5)) break;
                        --this.namespaceEnd;
                        string6 = string7;
                        break;
                    }
                }
                if (string6 == null) {
                    string6 = this.lookupOrDeclarePrefix(string);
                }
                if (string6.length() > 0) {
                    this.out.write(string6);
                    this.out.write(58);
                }
            } else {
                for (int i3 = this.namespaceEnd - 1; i3 >= 0; --i3) {
                    if (this.namespacePrefix[i3] != "") continue;
                    String string10 = this.namespaceUri[i3];
                    if (string10 == null) {
                        this.setPrefix("", "");
                        break;
                    }
                    if (string10.length() <= 0) break;
                    throw new IllegalStateException("start tag can not be written in empty default namespace as default namespace is currently bound to '" + string10 + "'" + this.getLocation());
                }
            }
        }
        this.out.write(string2);
        return this;
    }

    @Override
    public XmlSerializer attribute(String string, String string2, String string3) throws IOException {
        if (!this.startTagIncomplete) {
            throw new IllegalArgumentException("startTag() must be called before attribute()" + this.getLocation());
        }
        this.out.write(32);
        if (string != null && string.length() > 0) {
            if (!this.namesInterned) {
                string = string.intern();
            } else if (this.checkNamesInterned) {
                this.checkInterning(string);
            }
            String string4 = this.lookupOrDeclarePrefix(string);
            if (string4.length() == 0) {
                string4 = this.generatePrefix(string);
            }
            this.out.write(string4);
            this.out.write(58);
        }
        this.out.write(string2);
        this.out.write(61);
        this.out.write(this.attributeUseApostrophe ? 39 : 34);
        this.writeAttributeValue(string3, this.out);
        this.out.write(this.attributeUseApostrophe ? 39 : 34);
        return this;
    }

    protected void closeStartTag() throws IOException {
        if (this.finished) {
            throw new IllegalArgumentException("trying to write past already finished output" + this.getLocation());
        }
        if (this.seenBracket) {
            this.seenBracketBracket = false;
            this.seenBracket = false;
        }
        if (this.startTagIncomplete || this.setPrefixCalled) {
            if (this.setPrefixCalled) {
                throw new IllegalArgumentException("startTag() must be called immediately after setPrefix()" + this.getLocation());
            }
            if (!this.startTagIncomplete) {
                throw new IllegalArgumentException("trying to close start tag that is not opened" + this.getLocation());
            }
            this.writeNamespaceDeclarations();
            this.out.write(62);
            this.elNamespaceCount[this.depth] = this.namespaceEnd;
            this.startTagIncomplete = false;
        }
    }

    private void writeNamespaceDeclarations() throws IOException {
        for (int i2 = this.elNamespaceCount[this.depth - 1]; i2 < this.namespaceEnd; ++i2) {
            if (this.doIndent && this.namespaceUri[i2].length() > 40) {
                this.writeIndent();
                this.out.write(" ");
            }
            if (this.namespacePrefix[i2] != "") {
                this.out.write(" xmlns:");
                this.out.write(this.namespacePrefix[i2]);
                this.out.write(61);
            } else {
                this.out.write(" xmlns=");
            }
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            this.writeAttributeValue(this.namespaceUri[i2], this.out);
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
        }
    }

    @Override
    public XmlSerializer endTag(String string, String string2) throws IOException {
        this.seenBracketBracket = false;
        this.seenBracket = false;
        if (string != null) {
            if (!this.namesInterned) {
                string = string.intern();
            } else if (this.checkNamesInterned) {
                this.checkInterning(string);
            }
        }
        if (string != this.elNamespace[this.depth]) {
            throw new IllegalArgumentException("expected namespace " + MXSerializer.printable(this.elNamespace[this.depth]) + " and not " + MXSerializer.printable(string) + this.getLocation());
        }
        if (string2 == null) {
            throw new IllegalArgumentException("end tag name can not be null" + this.getLocation());
        }
        if (this.checkNamesInterned && this.namesInterned) {
            this.checkInterning(string2);
        }
        if (!this.namesInterned && !string2.equals(this.elName[this.depth]) || this.namesInterned && string2 != this.elName[this.depth]) {
            throw new IllegalArgumentException("expected element name " + MXSerializer.printable(this.elName[this.depth]) + " and not " + MXSerializer.printable(string2) + this.getLocation());
        }
        if (this.startTagIncomplete) {
            this.writeNamespaceDeclarations();
            this.out.write(" />");
            --this.depth;
        } else {
            String string3;
            --this.depth;
            if (this.doIndent && this.seenTag) {
                this.writeIndent();
            }
            this.out.write("</");
            if (string != null && string.length() > 0 && (string3 = this.lookupOrDeclarePrefix(string)).length() > 0) {
                this.out.write(string3);
                this.out.write(58);
            }
            this.out.write(string2);
            this.out.write(62);
        }
        this.namespaceEnd = this.elNamespaceCount[this.depth];
        this.startTagIncomplete = false;
        this.seenTag = true;
        return this;
    }

    @Override
    public XmlSerializer text(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(string, this.out);
        return this;
    }

    @Override
    public XmlSerializer text(char[] cArray, int n2, int n3) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(cArray, n2, n3, this.out);
        return this;
    }

    @Override
    public void cdsect(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<![CDATA[");
        this.out.write(string);
        this.out.write("]]>");
    }

    @Override
    public void entityRef(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write(38);
        this.out.write(string);
        this.out.write(59);
    }

    @Override
    public void processingInstruction(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<?");
        this.out.write(string);
        this.out.write("?>");
    }

    @Override
    public void comment(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<!--");
        this.out.write(string);
        this.out.write("-->");
    }

    @Override
    public void docdecl(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<!DOCTYPE ");
        this.out.write(string);
        this.out.write(">");
    }

    @Override
    public void ignorableWhitespace(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty string is not allowed for ignorable whitespace" + this.getLocation());
        }
        this.out.write(string);
    }

    @Override
    public void flush() throws IOException {
        if (!this.finished && this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.out.flush();
    }

    protected void writeAttributeValue(String string, Writer writer) throws IOException {
        char c2 = this.attributeUseApostrophe ? (char)'\'' : '\"';
        String string2 = this.attributeUseApostrophe ? "&apos;" : "&quot;";
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == '&') {
                if (i2 > n2) {
                    writer.write(string.substring(n2, i2));
                }
                writer.write("&amp;");
                n2 = i2 + 1;
            }
            if (c3 == '<') {
                if (i2 > n2) {
                    writer.write(string.substring(n2, i2));
                }
                writer.write("&lt;");
                n2 = i2 + 1;
                continue;
            }
            if (c3 == c2) {
                if (i2 > n2) {
                    writer.write(string.substring(n2, i2));
                }
                writer.write(string2);
                n2 = i2 + 1;
                continue;
            }
            if (c3 >= ' ') continue;
            if (c3 == '\r' || c3 == '\n' || c3 == '\t') {
                if (i2 > n2) {
                    writer.write(string.substring(n2, i2));
                }
                writer.write("&#");
                writer.write(Integer.toString(c3));
                writer.write(59);
                n2 = i2 + 1;
                continue;
            }
            throw new IllegalStateException("character " + Integer.toString(c3) + " is not allowed in output" + this.getLocation());
        }
        if (n2 > 0) {
            writer.write(string.substring(n2));
        } else {
            writer.write(string);
        }
    }

    protected void writeElementContent(String string, Writer writer) throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ']') {
                if (this.seenBracket) {
                    this.seenBracketBracket = true;
                    continue;
                }
                this.seenBracket = true;
                continue;
            }
            if (c2 == '&') {
                if (i2 > n2) {
                    writer.write(string.substring(n2, i2));
                }
                writer.write("&amp;");
                n2 = i2 + 1;
            } else if (c2 == '<') {
                if (i2 > n2) {
                    writer.write(string.substring(n2, i2));
                }
                writer.write("&lt;");
                n2 = i2 + 1;
            } else if (this.seenBracketBracket && c2 == '>') {
                if (i2 > n2) {
                    writer.write(string.substring(n2, i2));
                }
                writer.write("&gt;");
                n2 = i2 + 1;
            } else if (c2 < ' ' && c2 != '\t' && c2 != '\n' && c2 != '\r') {
                throw new IllegalStateException("character " + Integer.toString(c2) + " is not allowed in output" + this.getLocation());
            }
            if (!this.seenBracket) continue;
            this.seenBracket = false;
            this.seenBracketBracket = false;
        }
        if (n2 > 0) {
            writer.write(string.substring(n2));
        } else {
            writer.write(string);
        }
    }

    protected void writeElementContent(char[] cArray, int n2, int n3, Writer writer) throws IOException {
        int n4 = n2 + n3;
        int n5 = n2;
        for (int i2 = n2; i2 < n4; ++i2) {
            char c2 = cArray[i2];
            if (c2 == ']') {
                if (this.seenBracket) {
                    this.seenBracketBracket = true;
                    continue;
                }
                this.seenBracket = true;
                continue;
            }
            if (c2 == '&') {
                if (i2 > n5) {
                    writer.write(cArray, n5, i2 - n5);
                }
                writer.write("&amp;");
                n5 = i2 + 1;
            } else if (c2 == '<') {
                if (i2 > n5) {
                    writer.write(cArray, n5, i2 - n5);
                }
                writer.write("&lt;");
                n5 = i2 + 1;
            } else if (this.seenBracketBracket && c2 == '>') {
                if (i2 > n5) {
                    writer.write(cArray, n5, i2 - n5);
                }
                writer.write("&gt;");
                n5 = i2 + 1;
            } else if (c2 < ' ' && c2 != '\t' && c2 != '\n' && c2 != '\r') {
                throw new IllegalStateException("character " + Integer.toString(c2) + " is not allowed in output" + this.getLocation());
            }
            if (!this.seenBracket) continue;
            this.seenBracket = false;
            this.seenBracketBracket = false;
        }
        if (n4 > n5) {
            writer.write(cArray, n5, n4 - n5);
        }
    }

    protected static final String printable(String string) {
        if (string == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        stringBuilder.append("'");
        for (int i2 = 0; i2 < string.length(); ++i2) {
            MXSerializer.addPrintable(stringBuilder, string.charAt(i2));
        }
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    protected static final String printable(char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        MXSerializer.addPrintable(stringBuilder, c2);
        return stringBuilder.toString();
    }

    private static void addPrintable(StringBuilder stringBuilder, char c2) {
        switch (c2) {
            case '\b': {
                stringBuilder.append("\\b");
                break;
            }
            case '\t': {
                stringBuilder.append("\\t");
                break;
            }
            case '\n': {
                stringBuilder.append("\\n");
                break;
            }
            case '\f': {
                stringBuilder.append("\\f");
                break;
            }
            case '\r': {
                stringBuilder.append("\\r");
                break;
            }
            case '\"': {
                stringBuilder.append("\\\"");
                break;
            }
            case '\'': {
                stringBuilder.append("\\'");
                break;
            }
            case '\\': {
                stringBuilder.append("\\\\");
                break;
            }
            default: {
                if (c2 < ' ' || c2 > '~') {
                    String string = "0000" + Integer.toString(c2, 16);
                    stringBuilder.append("\\u").append(string, string.length() - 4, string.length());
                    break;
                }
                stringBuilder.append(c2);
            }
        }
    }

    static {
        for (int i2 = 0; i2 < precomputedPrefixes.length; ++i2) {
            MXSerializer.precomputedPrefixes[i2] = ("n" + i2).intern();
        }
    }
}

