/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zz.org.sonatype.aether.RequestTrace;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectRequest {
    private Dependency root;
    private List<Dependency> dependencies = Collections.emptyList();
    private List<Dependency> managedDependencies = Collections.emptyList();
    private List<RemoteRepository> repositories = Collections.emptyList();
    private String context = "";
    private RequestTrace trace;

    public CollectRequest() {
    }

    public CollectRequest(Dependency dependency, List<RemoteRepository> list) {
        this.setRoot(dependency);
        this.setRepositories(list);
    }

    public CollectRequest(Dependency dependency, List<Dependency> list, List<RemoteRepository> list2) {
        this.setRoot(dependency);
        this.setDependencies(list);
        this.setRepositories(list2);
    }

    public CollectRequest(List<Dependency> list, List<Dependency> list2, List<RemoteRepository> list3) {
        this.setDependencies(list);
        this.setManagedDependencies(list2);
        this.setRepositories(list3);
    }

    public Dependency getRoot() {
        return this.root;
    }

    public CollectRequest setRoot(Dependency dependency) {
        this.root = dependency;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public CollectRequest setDependencies(List<Dependency> list) {
        this.dependencies = list == null ? Collections.emptyList() : list;
        return this;
    }

    public CollectRequest addDependency(Dependency dependency) {
        if (dependency != null) {
            if (this.dependencies.isEmpty()) {
                this.dependencies = new ArrayList<Dependency>();
            }
            this.dependencies.add(dependency);
        }
        return this;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public CollectRequest setManagedDependencies(List<Dependency> list) {
        this.managedDependencies = list == null ? Collections.emptyList() : list;
        return this;
    }

    public CollectRequest addManagedDependency(Dependency dependency) {
        if (dependency != null) {
            if (this.managedDependencies.isEmpty()) {
                this.managedDependencies = new ArrayList<Dependency>();
            }
            this.managedDependencies.add(dependency);
        }
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public CollectRequest setRepositories(List<RemoteRepository> list) {
        this.repositories = list == null ? Collections.emptyList() : list;
        return this;
    }

    public CollectRequest addRepository(RemoteRepository remoteRepository) {
        if (remoteRepository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new ArrayList<RemoteRepository>();
            }
            this.repositories.add(remoteRepository);
        }
        return this;
    }

    public String getRequestContext() {
        return this.context;
    }

    public CollectRequest setRequestContext(String string) {
        this.context = string != null ? string : "";
        return this;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public CollectRequest setTrace(RequestTrace requestTrace) {
        this.trace = requestTrace;
        return this;
    }

    public String toString() {
        return this.getRoot() + " -> " + this.getDependencies() + " < " + this.getRepositories();
    }
}

