/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.collection;

import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.collection.CollectRequest;
import zz.org.sonatype.aether.collection.CollectResult;

public class DependencyCollectionException
extends RepositoryException {
    private final CollectResult result;

    public DependencyCollectionException(CollectResult collectResult) {
        super("Failed to collect dependencies for " + DependencyCollectionException.getSource(collectResult), DependencyCollectionException.getCause(collectResult));
        this.result = collectResult;
    }

    public CollectResult getResult() {
        return this.result;
    }

    private static String getSource(CollectResult collectResult) {
        if (collectResult == null) {
            return "";
        }
        CollectRequest collectRequest = collectResult.getRequest();
        if (collectRequest.getRoot() != null) {
            return collectRequest.getRoot().toString();
        }
        return collectRequest.getDependencies().toString();
    }

    private static Throwable getCause(CollectResult collectResult) {
        Throwable throwable = null;
        if (collectResult != null && !collectResult.getExceptions().isEmpty()) {
            throwable = collectResult.getExceptions().get(0);
        }
        return throwable;
    }
}

