/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsolvableVersionConflictException
extends RepositoryException {
    private final Object dependencyConflictId;
    private final Collection<String> versions;
    private final Collection<List<DependencyNode>> paths;

    public UnsolvableVersionConflictException(Object object, Collection<String> collection) {
        super("Could not resolve version conflict for " + object + " with requested versions " + UnsolvableVersionConflictException.toList(collection));
        this.dependencyConflictId = object != null ? object : "";
        this.versions = collection != null ? collection : Collections.emptyList();
        this.paths = Collections.emptyList();
    }

    private static String toList(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (collection != null) {
            for (String string : collection) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public UnsolvableVersionConflictException(Collection<List<DependencyNode>> collection, Object object) {
        super("Could not resolve version conflict among " + UnsolvableVersionConflictException.toPaths(collection));
        Object object2 = this.dependencyConflictId = object != null ? object : "";
        if (collection == null) {
            this.paths = Collections.emptyList();
            this.versions = Collections.emptyList();
        } else {
            this.paths = collection;
            this.versions = new LinkedHashSet<String>();
            for (List<DependencyNode> list : collection) {
                VersionConstraint versionConstraint = list.get(list.size() - 1).getVersionConstraint();
                if (versionConstraint == null || versionConstraint.getRanges().isEmpty()) continue;
                this.versions.add(versionConstraint.toString());
            }
        }
    }

    private static String toPaths(Collection<List<DependencyNode>> collection) {
        String string = "";
        if (collection != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (List<DependencyNode> list : collection) {
                linkedHashSet.add(UnsolvableVersionConflictException.toPath(list));
            }
            string = ((Object)linkedHashSet).toString();
        }
        return string;
    }

    private static String toPath(List<DependencyNode> list) {
        StringBuilder stringBuilder = new StringBuilder(256);
        Iterator<DependencyNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            DependencyNode dependencyNode = iterator.next();
            if (dependencyNode.getDependency() == null) continue;
            Artifact artifact = dependencyNode.getDependency().getArtifact();
            stringBuilder.append(artifact.getGroupId());
            stringBuilder.append(':').append(artifact.getArtifactId());
            stringBuilder.append(':').append(artifact.getExtension());
            if (artifact.getClassifier().length() > 0) {
                stringBuilder.append(':').append(artifact.getClassifier());
            }
            stringBuilder.append(':').append(dependencyNode.getVersionConstraint());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" -> ");
        }
        return stringBuilder.toString();
    }

    public Object getDependencyConflictId() {
        return this.dependencyConflictId;
    }

    public Collection<List<DependencyNode>> getPaths() {
        return this.paths;
    }

    public Collection<String> getVersions() {
        return this.versions;
    }
}

