/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.deployment;

import java.util.ArrayList;
import java.util.Collection;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.deployment.DeployRequest;
import zz.org.sonatype.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployResult {
    private final DeployRequest request;
    private Collection<Artifact> artifacts = new ArrayList<Artifact>();
    private Collection<Metadata> metadata = new ArrayList<Metadata>();

    public DeployResult(DeployRequest deployRequest) {
        if (deployRequest == null) {
            throw new IllegalArgumentException("deploy request has not been specified");
        }
        this.request = deployRequest;
    }

    public DeployRequest getRequest() {
        return this.request;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public DeployResult setArtifacts(Collection<Artifact> collection) {
        this.artifacts = collection == null ? new ArrayList<Artifact>() : collection;
        return this;
    }

    public DeployResult addArtifact(Artifact artifact) {
        if (artifact != null) {
            this.artifacts.add(artifact);
        }
        return this;
    }

    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public DeployResult setMetadata(Collection<Metadata> collection) {
        this.metadata = collection == null ? new ArrayList<Metadata>() : collection;
        return this;
    }

    public DeployResult addMetadata(Metadata metadata) {
        if (metadata != null) {
            this.metadata.add(metadata);
        }
        return this;
    }

    public String toString() {
        return this.getArtifacts() + ", " + this.getMetadata();
    }
}

