/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.graph;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.graph.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dependency {
    private final Artifact artifact;
    private final String scope;
    private final boolean optional;
    private final Set<Exclusion> exclusions;

    public Dependency(Artifact artifact, String string) {
        this(artifact, string, false);
    }

    public Dependency(Artifact artifact, String string, boolean bl2) {
        this(artifact, string, bl2, null);
    }

    public Dependency(Artifact artifact, String string, boolean bl2, Collection<Exclusion> collection) {
        this(artifact, string, Exclusions.copy(collection), bl2);
    }

    private Dependency(Artifact artifact, String string, Set<Exclusion> set, boolean bl2) {
        if (artifact == null) {
            throw new IllegalArgumentException("no artifact specified for dependency");
        }
        this.artifact = artifact;
        this.scope = string != null ? string : "";
        this.optional = bl2;
        this.exclusions = set;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Dependency setArtifact(Artifact artifact) {
        if (this.artifact.equals(artifact)) {
            return this;
        }
        return new Dependency(artifact, this.scope, this.exclusions, this.optional);
    }

    public String getScope() {
        return this.scope;
    }

    public Dependency setScope(String string) {
        if (this.scope.equals(string) || string == null && this.scope.length() <= 0) {
            return this;
        }
        return new Dependency(this.artifact, string, this.exclusions, this.optional);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Dependency setOptional(boolean bl2) {
        if (this.optional == bl2) {
            return this;
        }
        return new Dependency(this.artifact, this.scope, this.exclusions, bl2);
    }

    public Collection<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public Dependency setExclusions(Collection<Exclusion> collection) {
        if (this.hasEquivalentExclusions(collection)) {
            return this;
        }
        return new Dependency(this.artifact, this.scope, this.optional, collection);
    }

    private boolean hasEquivalentExclusions(Collection<Exclusion> collection) {
        if (collection == null || collection.isEmpty()) {
            return this.exclusions.isEmpty();
        }
        if (collection instanceof Set) {
            return ((Object)this.exclusions).equals(collection);
        }
        return collection.size() >= this.exclusions.size() && this.exclusions.containsAll(collection) && collection.containsAll(this.exclusions);
    }

    public String toString() {
        return String.valueOf(this.getArtifact()) + " (" + this.getScope() + (this.isOptional() ? "?" : "") + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Dependency dependency = (Dependency)object;
        return this.artifact.equals(dependency.artifact) && this.scope.equals(dependency.scope) && this.optional == dependency.optional && ((Object)this.exclusions).equals(dependency.exclusions);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + this.artifact.hashCode();
        n2 = n2 * 31 + this.scope.hashCode();
        n2 = n2 * 31 + (this.optional ? 1 : 0);
        n2 = n2 * 31 + this.exclusions.size();
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Exclusions
    extends AbstractSet<Exclusion> {
        private final Exclusion[] exclusions;

        public static Set<Exclusion> copy(Collection<Exclusion> collection) {
            if (collection == null || collection.isEmpty()) {
                return Collections.emptySet();
            }
            return new Exclusions(collection);
        }

        private Exclusions(Collection<Exclusion> collection) {
            if (collection.size() > 1 && !(collection instanceof Set)) {
                collection = new LinkedHashSet<Exclusion>(collection);
            }
            this.exclusions = collection.toArray(new Exclusion[collection.size()]);
        }

        @Override
        public Iterator<Exclusion> iterator() {
            return new Iterator<Exclusion>(){
                private int cursor = 0;

                @Override
                public boolean hasNext() {
                    return this.cursor < Exclusions.this.exclusions.length;
                }

                @Override
                public Exclusion next() {
                    try {
                        Exclusion exclusion = Exclusions.this.exclusions[this.cursor];
                        ++this.cursor;
                        return exclusion;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new NoSuchElementException();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.exclusions.length;
        }
    }
}

