/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.repository;

import java.io.File;
import zz.org.sonatype.aether.repository.ArtifactRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalRepository
implements ArtifactRepository {
    private final File basedir;
    private final String type;

    public LocalRepository(String string) {
        this(string != null ? new File(string) : null, "");
    }

    public LocalRepository(File file) {
        this(file, "");
    }

    public LocalRepository(File file, String string) {
        this.basedir = file;
        this.type = string != null ? string : "";
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    @Override
    public String getId() {
        return "local";
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String toString() {
        return this.getBasedir() + " (" + this.getContentType() + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LocalRepository localRepository = (LocalRepository)object;
        return LocalRepository.eq(this.basedir, localRepository.basedir) && LocalRepository.eq(this.type, localRepository.type);
    }

    private static <T> boolean eq(T t2, T t3) {
        return t2 != null ? t2.equals(t3) : t3 == null;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + LocalRepository.hash(this.basedir);
        n2 = n2 * 31 + LocalRepository.hash(this.type);
        return n2;
    }

    private static int hash(Object object) {
        return object != null ? object.hashCode() : 0;
    }
}

