/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.repository;

import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.repository.LocalRepository;

public class NoLocalRepositoryManagerException
extends RepositoryException {
    private final LocalRepository repository;

    public NoLocalRepositoryManagerException(LocalRepository localRepository) {
        this(localRepository, NoLocalRepositoryManagerException.toMessage(localRepository));
    }

    public NoLocalRepositoryManagerException(LocalRepository localRepository, String string) {
        super(string);
        this.repository = localRepository;
    }

    public NoLocalRepositoryManagerException(LocalRepository localRepository, Throwable throwable) {
        this(localRepository, NoLocalRepositoryManagerException.toMessage(localRepository), throwable);
    }

    public NoLocalRepositoryManagerException(LocalRepository localRepository, String string, Throwable throwable) {
        super(string, throwable);
        this.repository = localRepository;
    }

    private static String toMessage(LocalRepository localRepository) {
        if (localRepository != null) {
            return "No manager available for local repository (" + localRepository.getBasedir().getAbsolutePath() + ") of type " + localRepository.getContentType();
        }
        return "No connector available to access repository";
    }

    public LocalRepository getRepository() {
        return this.repository;
    }
}

