/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.repository;

import zz.org.sonatype.aether.repository.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Proxy {
    public static final String TYPE_HTTP = "http";
    public static final String TYPE_HTTPS = "https";
    private final String type;
    private final String host;
    private final int port;
    private final Authentication auth;

    public Proxy(String string, String string2, int n2, Authentication authentication) {
        this.type = string != null ? string : "";
        this.host = string2 != null ? string2 : "";
        this.port = n2;
        this.auth = authentication;
    }

    public String getType() {
        return this.type;
    }

    public Proxy setType(String string) {
        if (this.type.equals(string) || string == null && this.type.length() <= 0) {
            return this;
        }
        return new Proxy(string, this.host, this.port, this.auth);
    }

    public String getHost() {
        return this.host;
    }

    public Proxy setHost(String string) {
        if (this.host.equals(string) || string == null && this.host.length() <= 0) {
            return this;
        }
        return new Proxy(this.type, string, this.port, this.auth);
    }

    public int getPort() {
        return this.port;
    }

    public Proxy setPort(int n2) {
        if (this.port == n2) {
            return this;
        }
        return new Proxy(this.type, this.host, n2, this.auth);
    }

    public Authentication getAuthentication() {
        return this.auth;
    }

    public Proxy setAuthentication(Authentication authentication) {
        if (Proxy.eq(this.auth, authentication)) {
            return this;
        }
        return new Proxy(this.type, this.host, this.port, authentication);
    }

    public String toString() {
        return this.getHost() + ':' + this.getPort();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Proxy proxy = (Proxy)object;
        return Proxy.eq(this.type, proxy.type) && Proxy.eq(this.host, proxy.host) && this.port == proxy.port && Proxy.eq(this.auth, proxy.auth);
    }

    private static <T> boolean eq(T t2, T t3) {
        return t2 != null ? t2.equals(t3) : t3 == null;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + Proxy.hash(this.host);
        n2 = n2 * 31 + Proxy.hash(this.type);
        n2 = n2 * 31 + this.port;
        n2 = n2 * 31 + Proxy.hash(this.auth);
        return n2;
    }

    private static int hash(Object object) {
        return object != null ? object.hashCode() : 0;
    }
}

