/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.repository;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.org.sonatype.aether.repository.ArtifactRepository;
import zz.org.sonatype.aether.repository.Authentication;
import zz.org.sonatype.aether.repository.Proxy;
import zz.org.sonatype.aether.repository.RepositoryPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRepository
implements ArtifactRepository {
    private static final Pattern URL_PATTERN = Pattern.compile("([^:/]+(:[^:/]{2,}+(?=://))?):(//([^@/]*@)?([^/:]+))?.*");
    private String id = "";
    private String type = "";
    private String url = "";
    private RepositoryPolicy releasePolicy;
    private RepositoryPolicy snapshotPolicy;
    private Proxy proxy;
    private Authentication authentication;
    private List<RemoteRepository> mirroredRepositories = Collections.emptyList();
    private boolean repositoryManager;

    public RemoteRepository() {
        this.setPolicy(true, null);
        this.setPolicy(false, null);
    }

    public RemoteRepository(RemoteRepository remoteRepository) {
        this.setId(remoteRepository.getId());
        this.setContentType(remoteRepository.getContentType());
        this.setUrl(remoteRepository.getUrl());
        this.setPolicy(true, remoteRepository.getPolicy(true));
        this.setPolicy(false, remoteRepository.getPolicy(false));
        this.setAuthentication(remoteRepository.getAuthentication());
        this.setProxy(remoteRepository.getProxy());
        this.setMirroredRepositories(remoteRepository.getMirroredRepositories());
        this.setRepositoryManager(remoteRepository.isRepositoryManager());
    }

    public RemoteRepository(String string, String string2, String string3) {
        this.setId(string);
        this.setContentType(string2);
        this.setUrl(string3);
        this.setPolicy(true, null);
        this.setPolicy(false, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public RemoteRepository setId(String string) {
        this.id = string != null ? string : "";
        return this;
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    public RemoteRepository setContentType(String string) {
        this.type = string != null ? string : "";
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public RemoteRepository setUrl(String string) {
        this.url = string != null ? string : "";
        return this;
    }

    public String getProtocol() {
        Matcher matcher = URL_PATTERN.matcher(this.url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    public String getHost() {
        String string;
        Matcher matcher = URL_PATTERN.matcher(this.url);
        if (matcher.matches() && (string = matcher.group(5)) != null) {
            return string;
        }
        return "";
    }

    public RepositoryPolicy getPolicy(boolean bl2) {
        return bl2 ? this.snapshotPolicy : this.releasePolicy;
    }

    public RemoteRepository setPolicy(boolean bl2, RepositoryPolicy repositoryPolicy) {
        if (repositoryPolicy == null) {
            repositoryPolicy = new RepositoryPolicy();
        }
        if (bl2) {
            this.snapshotPolicy = repositoryPolicy;
        } else {
            this.releasePolicy = repositoryPolicy;
        }
        return this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public RemoteRepository setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public RemoteRepository setAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public List<RemoteRepository> getMirroredRepositories() {
        return this.mirroredRepositories;
    }

    public RemoteRepository setMirroredRepositories(List<RemoteRepository> list) {
        this.mirroredRepositories = list == null || list.isEmpty() ? Collections.emptyList() : list;
        return this;
    }

    public boolean isRepositoryManager() {
        return this.repositoryManager;
    }

    public RemoteRepository setRepositoryManager(boolean bl2) {
        this.repositoryManager = bl2;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.getId());
        stringBuilder.append(" (").append(this.getUrl());
        boolean bl2 = this.getPolicy(false).isEnabled();
        boolean bl3 = this.getPolicy(true).isEnabled();
        if (bl2 && bl3) {
            stringBuilder.append(", releases+snapshots");
        } else if (bl2) {
            stringBuilder.append(", releases");
        } else if (bl3) {
            stringBuilder.append(", snapshots");
        } else {
            stringBuilder.append(", disabled");
        }
        if (this.isRepositoryManager()) {
            stringBuilder.append(", managed");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RemoteRepository remoteRepository = (RemoteRepository)object;
        return RemoteRepository.eq(this.url, remoteRepository.url) && RemoteRepository.eq(this.type, remoteRepository.type) && RemoteRepository.eq(this.id, remoteRepository.id) && RemoteRepository.eq(this.releasePolicy, remoteRepository.releasePolicy) && RemoteRepository.eq(this.snapshotPolicy, remoteRepository.snapshotPolicy) && RemoteRepository.eq(this.proxy, remoteRepository.proxy) && RemoteRepository.eq(this.authentication, remoteRepository.authentication) && RemoteRepository.eq(this.mirroredRepositories, remoteRepository.mirroredRepositories) && this.repositoryManager == remoteRepository.repositoryManager;
    }

    private static <T> boolean eq(T t2, T t3) {
        return t2 != null ? t2.equals(t3) : t3 == null;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + RemoteRepository.hash(this.url);
        n2 = n2 * 31 + RemoteRepository.hash(this.type);
        n2 = n2 * 31 + RemoteRepository.hash(this.id);
        n2 = n2 * 31 + RemoteRepository.hash(this.releasePolicy);
        n2 = n2 * 31 + RemoteRepository.hash(this.snapshotPolicy);
        n2 = n2 * 31 + RemoteRepository.hash(this.proxy);
        n2 = n2 * 31 + RemoteRepository.hash(this.authentication);
        n2 = n2 * 31 + RemoteRepository.hash(this.mirroredRepositories);
        n2 = n2 * 31 + (this.repositoryManager ? 1 : 0);
        return n2;
    }

    private static int hash(Object object) {
        return object != null ? object.hashCode() : 0;
    }
}

