/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.repository;

public final class RepositoryPolicy {
    public static final String UPDATE_POLICY_NEVER = "never";
    public static final String UPDATE_POLICY_ALWAYS = "always";
    public static final String UPDATE_POLICY_DAILY = "daily";
    public static final String UPDATE_POLICY_INTERVAL = "interval";
    public static final String CHECKSUM_POLICY_FAIL = "fail";
    public static final String CHECKSUM_POLICY_WARN = "warn";
    public static final String CHECKSUM_POLICY_IGNORE = "ignore";
    private final boolean enabled;
    private final String updatePolicy;
    private final String checksumPolicy;

    public RepositoryPolicy() {
        this(true, UPDATE_POLICY_DAILY, CHECKSUM_POLICY_WARN);
    }

    public RepositoryPolicy(boolean bl2, String string, String string2) {
        this.enabled = bl2;
        this.updatePolicy = string != null ? string : "";
        this.checksumPolicy = string2 != null ? string2 : "";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RepositoryPolicy setEnabled(boolean bl2) {
        if (this.enabled == bl2) {
            return this;
        }
        return new RepositoryPolicy(bl2, this.updatePolicy, this.checksumPolicy);
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public RepositoryPolicy setUpdatePolicy(String string) {
        if (this.updatePolicy.equals(string)) {
            return this;
        }
        return new RepositoryPolicy(this.enabled, string, this.checksumPolicy);
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public RepositoryPolicy setChecksumPolicy(String string) {
        if (this.checksumPolicy.equals(string)) {
            return this;
        }
        return new RepositoryPolicy(this.enabled, this.updatePolicy, string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("enabled=").append(this.isEnabled());
        stringBuilder.append(", checksums=").append(this.getChecksumPolicy());
        stringBuilder.append(", updates=").append(this.getUpdatePolicy());
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RepositoryPolicy repositoryPolicy = (RepositoryPolicy)object;
        return this.enabled == repositoryPolicy.enabled && this.updatePolicy.equals(repositoryPolicy.updatePolicy) && this.checksumPolicy.equals(repositoryPolicy.checksumPolicy);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + (this.enabled ? 1 : 0);
        n2 = n2 * 31 + this.updatePolicy.hashCode();
        n2 = n2 * 31 + this.checksumPolicy.hashCode();
        return n2;
    }
}

