/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.resolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.repository.ArtifactRepository;
import zz.org.sonatype.aether.repository.RemoteRepository;
import zz.org.sonatype.aether.resolution.ArtifactDescriptorRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactDescriptorResult {
    private final ArtifactDescriptorRequest request;
    private List<Exception> exceptions;
    private List<Artifact> relocations;
    private Collection<Artifact> aliases;
    private Artifact artifact;
    private ArtifactRepository repository;
    private List<Dependency> dependencies;
    private List<Dependency> managedDependencies;
    private List<RemoteRepository> repositories;
    private Map<String, Object> properties;

    public ArtifactDescriptorResult(ArtifactDescriptorRequest artifactDescriptorRequest) {
        if (artifactDescriptorRequest == null) {
            throw new IllegalArgumentException("artifact descriptor request has not been specified");
        }
        this.request = artifactDescriptorRequest;
        this.artifact = artifactDescriptorRequest.getArtifact();
        this.exceptions = new ArrayList<Exception>(2);
        this.relocations = new ArrayList<Artifact>(2);
        this.aliases = new ArrayList<Artifact>(1);
        this.dependencies = new ArrayList<Dependency>();
        this.managedDependencies = new ArrayList<Dependency>();
        this.repositories = new ArrayList<RemoteRepository>();
        this.properties = Collections.emptyMap();
    }

    public ArtifactDescriptorRequest getRequest() {
        return this.request;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public ArtifactDescriptorResult setExceptions(List<Exception> list) {
        this.exceptions = list == null ? new ArrayList<Exception>(2) : list;
        return this;
    }

    public ArtifactDescriptorResult addException(Exception exception) {
        if (exception != null) {
            this.exceptions.add(exception);
        }
        return this;
    }

    public List<Artifact> getRelocations() {
        return this.relocations;
    }

    public ArtifactDescriptorResult setRelocations(List<Artifact> list) {
        this.relocations = list == null ? new ArrayList<Artifact>(2) : list;
        return this;
    }

    public ArtifactDescriptorResult addRelocation(Artifact artifact) {
        if (artifact != null) {
            this.relocations.add(artifact);
        }
        return this;
    }

    public Collection<Artifact> getAliases() {
        return this.aliases;
    }

    public ArtifactDescriptorResult setAliases(Collection<Artifact> collection) {
        this.aliases = collection == null ? new ArrayList<Artifact>(0) : collection;
        return this;
    }

    public ArtifactDescriptorResult addAlias(Artifact artifact) {
        if (artifact != null) {
            this.aliases.add(artifact);
        }
        return this;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactDescriptorResult setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public ArtifactDescriptorResult setRepository(ArtifactRepository artifactRepository) {
        this.repository = artifactRepository;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public ArtifactDescriptorResult setDependencies(List<Dependency> list) {
        this.dependencies = list == null ? new ArrayList<Dependency>() : list;
        return this;
    }

    public ArtifactDescriptorResult addDependency(Dependency dependency) {
        if (dependency != null) {
            this.dependencies.add(dependency);
        }
        return this;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public ArtifactDescriptorResult setManagedDependencies(List<Dependency> list) {
        this.managedDependencies = list == null ? new ArrayList<Dependency>() : list;
        return this;
    }

    public ArtifactDescriptorResult addManagedDependency(Dependency dependency) {
        if (dependency != null) {
            this.managedDependencies.add(dependency);
        }
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public ArtifactDescriptorResult setRepositories(List<RemoteRepository> list) {
        this.repositories = list == null ? new ArrayList<RemoteRepository>(2) : list;
        return this;
    }

    public ArtifactDescriptorResult addRepository(RemoteRepository remoteRepository) {
        if (remoteRepository != null) {
            this.repositories.add(remoteRepository);
        }
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ArtifactDescriptorResult setProperties(Map<String, Object> map) {
        this.properties = map == null ? Collections.emptyMap() : map;
        return this;
    }

    public String toString() {
        return this.getArtifact() + " -> " + this.getDependencies();
    }
}

