/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.resolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zz.org.sonatype.aether.RequestTrace;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactRequest {
    private Artifact artifact;
    private DependencyNode node;
    private List<RemoteRepository> repositories = Collections.emptyList();
    private String context = "";
    private RequestTrace trace;

    public ArtifactRequest() {
    }

    public ArtifactRequest(Artifact artifact, List<RemoteRepository> list, String string) {
        this.setArtifact(artifact);
        this.setRepositories(list);
        this.setRequestContext(string);
    }

    public ArtifactRequest(DependencyNode dependencyNode) {
        this.setDependencyNode(dependencyNode);
        this.setRepositories(dependencyNode.getRepositories());
        this.setRequestContext(dependencyNode.getRequestContext());
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactRequest setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public DependencyNode getDependencyNode() {
        return this.node;
    }

    public ArtifactRequest setDependencyNode(DependencyNode dependencyNode) {
        this.node = dependencyNode;
        if (dependencyNode != null) {
            this.setArtifact(dependencyNode.getDependency().getArtifact());
        }
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public ArtifactRequest setRepositories(List<RemoteRepository> list) {
        this.repositories = list == null ? Collections.emptyList() : list;
        return this;
    }

    public ArtifactRequest addRepository(RemoteRepository remoteRepository) {
        if (remoteRepository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new ArrayList<RemoteRepository>();
            }
            this.repositories.add(remoteRepository);
        }
        return this;
    }

    public String getRequestContext() {
        return this.context;
    }

    public ArtifactRequest setRequestContext(String string) {
        this.context = string != null ? string : "";
        return this;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public ArtifactRequest setTrace(RequestTrace requestTrace) {
        this.trace = requestTrace;
        return this;
    }

    public String toString() {
        return this.getArtifact() + " < " + this.getRepositories();
    }
}

