/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.resolution;

import java.util.Collections;
import java.util.List;
import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.resolution.ArtifactResult;
import zz.org.sonatype.aether.transfer.ArtifactNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResolutionException
extends RepositoryException {
    private final List<ArtifactResult> results;

    public ArtifactResolutionException(List<ArtifactResult> list) {
        super(ArtifactResolutionException.getMessage(list), ArtifactResolutionException.getCause(list));
        this.results = list != null ? list : Collections.emptyList();
    }

    public List<ArtifactResult> getResults() {
        return this.results;
    }

    public ArtifactResult getResult() {
        return !this.results.isEmpty() ? this.results.get(0) : null;
    }

    private static String getMessage(List<? extends ArtifactResult> list) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("The following artifacts could not be resolved: ");
        int n2 = 0;
        String string = "";
        for (ArtifactResult artifactResult : list) {
            if (artifactResult.isResolved()) continue;
            ++n2;
            stringBuilder.append(string);
            stringBuilder.append(artifactResult.getRequest().getArtifact());
            string = ", ";
        }
        Throwable throwable = ArtifactResolutionException.getCause(list);
        if (throwable != null) {
            if (n2 == 1) {
                stringBuilder.setLength(0);
                stringBuilder.append(throwable.getMessage());
            } else {
                stringBuilder.append(": ").append(throwable.getMessage());
            }
        }
        return stringBuilder.toString();
    }

    private static Throwable getCause(List<? extends ArtifactResult> list) {
        for (ArtifactResult artifactResult : list) {
            if (artifactResult.isResolved()) continue;
            Exception exception = null;
            for (Exception exception2 : artifactResult.getExceptions()) {
                if (exception2 instanceof ArtifactNotFoundException) {
                    if (exception != null) continue;
                    exception = exception2;
                    continue;
                }
                return exception2;
            }
            if (exception == null) continue;
            return exception;
        }
        return null;
    }
}

