/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.resolution;

import java.util.ArrayList;
import java.util.List;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.repository.ArtifactRepository;
import zz.org.sonatype.aether.resolution.ArtifactRequest;
import zz.org.sonatype.aether.transfer.ArtifactNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResult {
    private final ArtifactRequest request;
    private final List<Exception> exceptions;
    private Artifact artifact;
    private ArtifactRepository repository;

    public ArtifactResult(ArtifactRequest artifactRequest) {
        if (artifactRequest == null) {
            throw new IllegalArgumentException("resolution request has not been specified");
        }
        this.request = artifactRequest;
        this.exceptions = new ArrayList<Exception>(2);
    }

    public ArtifactRequest getRequest() {
        return this.request;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactResult setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public ArtifactResult addException(Exception exception) {
        if (exception != null) {
            this.exceptions.add(exception);
        }
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public ArtifactResult setRepository(ArtifactRepository artifactRepository) {
        this.repository = artifactRepository;
        return this;
    }

    public boolean isResolved() {
        return this.getArtifact() != null && this.getArtifact().getFile() != null;
    }

    public boolean isMissing() {
        for (Exception exception : this.getExceptions()) {
            if (exception instanceof ArtifactNotFoundException) continue;
            return false;
        }
        return !this.isResolved();
    }

    public String toString() {
        return this.getArtifact() + " < " + this.getRepository();
    }
}

