/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.resolution;

import zz.org.sonatype.aether.metadata.Metadata;
import zz.org.sonatype.aether.resolution.MetadataRequest;
import zz.org.sonatype.aether.transfer.MetadataNotFoundException;

public class MetadataResult {
    private final MetadataRequest request;
    private Exception exception;
    private boolean updated;
    private Metadata metadata;

    public MetadataResult(MetadataRequest metadataRequest) {
        if (metadataRequest == null) {
            throw new IllegalArgumentException("metadata request has not been specified");
        }
        this.request = metadataRequest;
    }

    public MetadataRequest getRequest() {
        return this.request;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public MetadataResult setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public MetadataResult setException(Exception exception) {
        this.exception = exception;
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    public MetadataResult setUpdated(boolean bl2) {
        this.updated = bl2;
        return this;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isResolved() {
        return this.getMetadata() != null && this.getMetadata().getFile() != null;
    }

    public boolean isMissing() {
        return this.getException() instanceof MetadataNotFoundException;
    }

    public String toString() {
        return this.getMetadata() + (this.isUpdated() ? " (updated)" : " (cached)");
    }
}

