/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.resolution;

import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.resolution.VersionRangeResult;

public class VersionRangeResolutionException
extends RepositoryException {
    private final VersionRangeResult result;

    public VersionRangeResolutionException(VersionRangeResult versionRangeResult) {
        super(VersionRangeResolutionException.getMessage(versionRangeResult), VersionRangeResolutionException.getCause(versionRangeResult));
        this.result = versionRangeResult;
    }

    private static String getMessage(VersionRangeResult versionRangeResult) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Failed to resolve version range");
        if (versionRangeResult != null) {
            stringBuilder.append(" for ").append(versionRangeResult.getRequest().getArtifact());
            if (!versionRangeResult.getExceptions().isEmpty()) {
                stringBuilder.append(": ").append(versionRangeResult.getExceptions().iterator().next().getMessage());
            }
        }
        return stringBuilder.toString();
    }

    private static Throwable getCause(VersionRangeResult versionRangeResult) {
        Throwable throwable = null;
        if (versionRangeResult != null && !versionRangeResult.getExceptions().isEmpty()) {
            throwable = versionRangeResult.getExceptions().get(0);
        }
        return throwable;
    }

    public VersionRangeResolutionException(VersionRangeResult versionRangeResult, String string) {
        super(string);
        this.result = versionRangeResult;
    }

    public VersionRangeResult getResult() {
        return this.result;
    }
}

