/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.resolution;

import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.resolution.VersionResult;

public class VersionResolutionException
extends RepositoryException {
    private final VersionResult result;

    public VersionResolutionException(VersionResult versionResult) {
        super(VersionResolutionException.getMessage(versionResult), VersionResolutionException.getCause(versionResult));
        this.result = versionResult;
    }

    private static String getMessage(VersionResult versionResult) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Failed to resolve version");
        if (versionResult != null) {
            stringBuilder.append(" for ").append(versionResult.getRequest().getArtifact());
            if (!versionResult.getExceptions().isEmpty()) {
                stringBuilder.append(": ").append(versionResult.getExceptions().iterator().next().getMessage());
            }
        }
        return stringBuilder.toString();
    }

    private static Throwable getCause(VersionResult versionResult) {
        Throwable throwable = null;
        if (versionResult != null && !versionResult.getExceptions().isEmpty()) {
            throwable = versionResult.getExceptions().get(0);
        }
        return throwable;
    }

    public VersionResult getResult() {
        return this.result;
    }
}

