/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.transfer;

import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.repository.RemoteRepository;

public class ArtifactTransferException
extends RepositoryException {
    private final Artifact artifact;
    private final RemoteRepository repository;

    static String getString(String string, RemoteRepository remoteRepository) {
        if (remoteRepository == null) {
            return "";
        }
        return string + remoteRepository.getId() + " (" + remoteRepository.getUrl() + ")";
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository remoteRepository, String string) {
        super(string);
        this.artifact = artifact;
        this.repository = remoteRepository;
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository remoteRepository, Throwable throwable) {
        super("Could not transfer artifact " + artifact + ArtifactTransferException.getString(" from/to ", remoteRepository) + ArtifactTransferException.getMessage(": ", throwable), throwable);
        this.artifact = artifact;
        this.repository = remoteRepository;
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository remoteRepository, String string, Throwable throwable) {
        super(string, throwable);
        this.artifact = artifact;
        this.repository = remoteRepository;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }
}

