/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import zz.org.sonatype.aether.RepositoryCache;
import zz.org.sonatype.aether.RepositoryListener;
import zz.org.sonatype.aether.RepositorySystemSession;
import zz.org.sonatype.aether.SessionData;
import zz.org.sonatype.aether.artifact.ArtifactType;
import zz.org.sonatype.aether.artifact.ArtifactTypeRegistry;
import zz.org.sonatype.aether.collection.DependencyGraphTransformer;
import zz.org.sonatype.aether.collection.DependencyManager;
import zz.org.sonatype.aether.collection.DependencySelector;
import zz.org.sonatype.aether.collection.DependencyTraverser;
import zz.org.sonatype.aether.repository.Authentication;
import zz.org.sonatype.aether.repository.AuthenticationSelector;
import zz.org.sonatype.aether.repository.LocalRepository;
import zz.org.sonatype.aether.repository.LocalRepositoryManager;
import zz.org.sonatype.aether.repository.MirrorSelector;
import zz.org.sonatype.aether.repository.Proxy;
import zz.org.sonatype.aether.repository.ProxySelector;
import zz.org.sonatype.aether.repository.RemoteRepository;
import zz.org.sonatype.aether.repository.WorkspaceReader;
import zz.org.sonatype.aether.transfer.TransferListener;
import zz.org.sonatype.aether.util.DefaultSessionData;
import zz.org.sonatype.aether.util.graph.manager.NoopDependencyManager;
import zz.org.sonatype.aether.util.graph.selector.StaticDependencySelector;
import zz.org.sonatype.aether.util.graph.transformer.NoopDependencyGraphTransformer;
import zz.org.sonatype.aether.util.graph.traverser.StaticDependencyTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositorySystemSession
implements RepositorySystemSession {
    private static final DependencyTraverser TRAVERSER = new StaticDependencyTraverser(true);
    private static final DependencyManager MANAGER = NoopDependencyManager.INSTANCE;
    private static final DependencySelector SELECTOR = new StaticDependencySelector(true);
    private static final DependencyGraphTransformer TRANSFORMER = NoopDependencyGraphTransformer.INSTANCE;
    private boolean offline;
    private boolean transferErrorCachingEnabled;
    private boolean notFoundCachingEnabled;
    private boolean ignoreMissingArtifactDescriptor;
    private boolean ignoreInvalidArtifactDescriptor;
    private String checksumPolicy;
    private String updatePolicy;
    private LocalRepositoryManager localRepositoryManager;
    private WorkspaceReader workspaceReader;
    private RepositoryListener repositoryListener;
    private TransferListener transferListener;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> userProperties = new HashMap<String, String>();
    private Map<String, Object> configProperties = new HashMap<String, Object>();
    private MirrorSelector mirrorSelector = NullMirrorSelector.INSTANCE;
    private ProxySelector proxySelector = NullProxySelector.INSTANCE;
    private AuthenticationSelector authenticationSelector = NullAuthenticationSelector.INSTANCE;
    private ArtifactTypeRegistry artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
    private DependencyTraverser dependencyTraverser = TRAVERSER;
    private DependencyManager dependencyManager = MANAGER;
    private DependencySelector dependencySelector = SELECTOR;
    private DependencyGraphTransformer dependencyGraphTransformer = TRANSFORMER;
    private SessionData data = new DefaultSessionData();
    private RepositoryCache cache;

    public DefaultRepositorySystemSession() {
    }

    public DefaultRepositorySystemSession(RepositorySystemSession repositorySystemSession) {
        this.setOffline(repositorySystemSession.isOffline());
        this.setTransferErrorCachingEnabled(repositorySystemSession.isTransferErrorCachingEnabled());
        this.setNotFoundCachingEnabled(repositorySystemSession.isNotFoundCachingEnabled());
        this.setIgnoreInvalidArtifactDescriptor(repositorySystemSession.isIgnoreInvalidArtifactDescriptor());
        this.setIgnoreMissingArtifactDescriptor(repositorySystemSession.isIgnoreMissingArtifactDescriptor());
        this.setChecksumPolicy(repositorySystemSession.getChecksumPolicy());
        this.setUpdatePolicy(repositorySystemSession.getUpdatePolicy());
        this.setLocalRepositoryManager(repositorySystemSession.getLocalRepositoryManager());
        this.setWorkspaceReader(repositorySystemSession.getWorkspaceReader());
        this.setRepositoryListener(repositorySystemSession.getRepositoryListener());
        this.setTransferListener(repositorySystemSession.getTransferListener());
        this.setSystemProperties(repositorySystemSession.getSystemProperties());
        this.setUserProperties(repositorySystemSession.getUserProperties());
        this.setConfigProperties(repositorySystemSession.getConfigProperties());
        this.setMirrorSelector(repositorySystemSession.getMirrorSelector());
        this.setProxySelector(repositorySystemSession.getProxySelector());
        this.setAuthenticationSelector(repositorySystemSession.getAuthenticationSelector());
        this.setArtifactTypeRegistry(repositorySystemSession.getArtifactTypeRegistry());
        this.setDependencyTraverser(repositorySystemSession.getDependencyTraverser());
        this.setDependencyManager(repositorySystemSession.getDependencyManager());
        this.setDependencySelector(repositorySystemSession.getDependencySelector());
        this.setDependencyGraphTransformer(repositorySystemSession.getDependencyGraphTransformer());
        this.setData(repositorySystemSession.getData());
        this.setCache(repositorySystemSession.getCache());
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    public DefaultRepositorySystemSession setOffline(boolean bl2) {
        this.offline = bl2;
        return this;
    }

    @Override
    public boolean isTransferErrorCachingEnabled() {
        return this.transferErrorCachingEnabled;
    }

    public DefaultRepositorySystemSession setTransferErrorCachingEnabled(boolean bl2) {
        this.transferErrorCachingEnabled = bl2;
        return this;
    }

    @Override
    public boolean isNotFoundCachingEnabled() {
        return this.notFoundCachingEnabled;
    }

    public DefaultRepositorySystemSession setNotFoundCachingEnabled(boolean bl2) {
        this.notFoundCachingEnabled = bl2;
        return this;
    }

    @Override
    public boolean isIgnoreMissingArtifactDescriptor() {
        return this.ignoreMissingArtifactDescriptor;
    }

    public DefaultRepositorySystemSession setIgnoreMissingArtifactDescriptor(boolean bl2) {
        this.ignoreMissingArtifactDescriptor = bl2;
        return this;
    }

    @Override
    public boolean isIgnoreInvalidArtifactDescriptor() {
        return this.ignoreInvalidArtifactDescriptor;
    }

    public DefaultRepositorySystemSession setIgnoreInvalidArtifactDescriptor(boolean bl2) {
        this.ignoreInvalidArtifactDescriptor = bl2;
        return this;
    }

    @Override
    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public DefaultRepositorySystemSession setChecksumPolicy(String string) {
        this.checksumPolicy = string;
        return this;
    }

    @Override
    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public DefaultRepositorySystemSession setUpdatePolicy(String string) {
        this.updatePolicy = string;
        return this;
    }

    @Override
    public LocalRepository getLocalRepository() {
        LocalRepositoryManager localRepositoryManager = this.getLocalRepositoryManager();
        return localRepositoryManager != null ? localRepositoryManager.getRepository() : null;
    }

    @Override
    public LocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepositoryManager;
    }

    public DefaultRepositorySystemSession setLocalRepositoryManager(LocalRepositoryManager localRepositoryManager) {
        this.localRepositoryManager = localRepositoryManager;
        return this;
    }

    @Override
    public WorkspaceReader getWorkspaceReader() {
        return this.workspaceReader;
    }

    public DefaultRepositorySystemSession setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.workspaceReader = workspaceReader;
        return this;
    }

    @Override
    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public DefaultRepositorySystemSession setRepositoryListener(RepositoryListener repositoryListener) {
        this.repositoryListener = repositoryListener;
        return this;
    }

    @Override
    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public DefaultRepositorySystemSession setTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    private <T> Map<String, T> toSafeMap(Map<?, ?> map, Class<T> clazz) {
        HashMap<String, T> hashMap;
        if (map == null || map.isEmpty()) {
            hashMap = new HashMap<String, T>();
        } else {
            hashMap = new LinkedHashMap();
            for (Object obj : map.keySet()) {
                Object obj2;
                if (!(obj instanceof String) || !clazz.isInstance(obj2 = map.get(obj))) continue;
                hashMap.put(obj.toString(), clazz.cast(obj2));
            }
        }
        return hashMap;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public DefaultRepositorySystemSession setSystemProperties(Map<String, String> map) {
        this.systemProperties = map == null ? new HashMap<String, String>() : map;
        return this;
    }

    public DefaultRepositorySystemSession setSystemProps(Hashtable<?, ?> hashtable) {
        this.systemProperties = this.toSafeMap(hashtable, String.class);
        return this;
    }

    public DefaultRepositorySystemSession setSystemProperty(String string, String string2) {
        if (string2 != null) {
            this.systemProperties.put(string, string2);
        } else {
            this.systemProperties.remove(string);
        }
        return this;
    }

    @Override
    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public DefaultRepositorySystemSession setUserProperties(Map<String, String> map) {
        this.userProperties = map == null ? new HashMap<String, String>() : map;
        return this;
    }

    public DefaultRepositorySystemSession setUserProps(Map<?, ?> map) {
        this.userProperties = this.toSafeMap(map, String.class);
        return this;
    }

    public DefaultRepositorySystemSession setUserProperty(String string, String string2) {
        if (string2 != null) {
            this.userProperties.put(string, string2);
        } else {
            this.userProperties.remove(string);
        }
        return this;
    }

    @Override
    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public DefaultRepositorySystemSession setConfigProperties(Map<String, Object> map) {
        this.configProperties = map == null ? new HashMap<String, Object>() : map;
        return this;
    }

    public DefaultRepositorySystemSession setConfigProps(Map<?, ?> map) {
        this.configProperties = this.toSafeMap(map, Object.class);
        return this;
    }

    public DefaultRepositorySystemSession setConfigProperty(String string, Object object) {
        if (object != null) {
            this.configProperties.put(string, object);
        } else {
            this.configProperties.remove(string);
        }
        return this;
    }

    @Override
    public MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public DefaultRepositorySystemSession setMirrorSelector(MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
        if (this.mirrorSelector == null) {
            this.mirrorSelector = NullMirrorSelector.INSTANCE;
        }
        return this;
    }

    @Override
    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public DefaultRepositorySystemSession setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        if (this.proxySelector == null) {
            this.proxySelector = NullProxySelector.INSTANCE;
        }
        return this;
    }

    @Override
    public AuthenticationSelector getAuthenticationSelector() {
        return this.authenticationSelector;
    }

    public DefaultRepositorySystemSession setAuthenticationSelector(AuthenticationSelector authenticationSelector) {
        this.authenticationSelector = authenticationSelector;
        if (this.authenticationSelector == null) {
            this.authenticationSelector = NullAuthenticationSelector.INSTANCE;
        }
        return this;
    }

    @Override
    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    public DefaultRepositorySystemSession setArtifactTypeRegistry(ArtifactTypeRegistry artifactTypeRegistry) {
        this.artifactTypeRegistry = artifactTypeRegistry;
        if (this.artifactTypeRegistry == null) {
            this.artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
        }
        return this;
    }

    @Override
    public DependencyTraverser getDependencyTraverser() {
        return this.dependencyTraverser;
    }

    public DefaultRepositorySystemSession setDependencyTraverser(DependencyTraverser dependencyTraverser) {
        this.dependencyTraverser = dependencyTraverser;
        if (this.dependencyTraverser == null) {
            this.dependencyTraverser = TRAVERSER;
        }
        return this;
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public DefaultRepositorySystemSession setDependencyManager(DependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
        if (this.dependencyManager == null) {
            this.dependencyManager = MANAGER;
        }
        return this;
    }

    @Override
    public DependencySelector getDependencySelector() {
        return this.dependencySelector;
    }

    public DefaultRepositorySystemSession setDependencySelector(DependencySelector dependencySelector) {
        this.dependencySelector = dependencySelector;
        if (this.dependencySelector == null) {
            this.dependencySelector = SELECTOR;
        }
        return this;
    }

    @Override
    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public DefaultRepositorySystemSession setDependencyGraphTransformer(DependencyGraphTransformer dependencyGraphTransformer) {
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        if (this.dependencyGraphTransformer == null) {
            this.dependencyGraphTransformer = TRANSFORMER;
        }
        return this;
    }

    @Override
    public SessionData getData() {
        return this.data;
    }

    public DefaultRepositorySystemSession setData(SessionData sessionData) {
        this.data = sessionData;
        if (this.data == null) {
            this.data = new DefaultSessionData();
        }
        return this;
    }

    @Override
    public RepositoryCache getCache() {
        return this.cache;
    }

    public DefaultRepositorySystemSession setCache(RepositoryCache repositoryCache) {
        this.cache = repositoryCache;
        return this;
    }

    static class NullArtifactTypeRegistry
    implements ArtifactTypeRegistry {
        public static final ArtifactTypeRegistry INSTANCE = new NullArtifactTypeRegistry();

        NullArtifactTypeRegistry() {
        }

        public ArtifactType get(String string) {
            return null;
        }
    }

    static class NullAuthenticationSelector
    implements AuthenticationSelector {
        public static final AuthenticationSelector INSTANCE = new NullAuthenticationSelector();

        NullAuthenticationSelector() {
        }

        public Authentication getAuthentication(RemoteRepository remoteRepository) {
            return remoteRepository.getAuthentication();
        }
    }

    static class NullMirrorSelector
    implements MirrorSelector {
        public static final MirrorSelector INSTANCE = new NullMirrorSelector();

        NullMirrorSelector() {
        }

        public RemoteRepository getMirror(RemoteRepository remoteRepository) {
            return null;
        }
    }

    static class NullProxySelector
    implements ProxySelector {
        public static final ProxySelector INSTANCE = new NullProxySelector();

        NullProxySelector() {
        }

        public Proxy getProxy(RemoteRepository remoteRepository) {
            return remoteRepository.getProxy();
        }
    }
}

