/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.artifact;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArtifact
implements Artifact {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}.[0-9]{6}-[0-9]+)$");

    protected static boolean isSnapshot(String string) {
        return string.endsWith(SNAPSHOT) || SNAPSHOT_TIMESTAMP.matcher(string).matches();
    }

    protected static String toBaseVersion(String string) {
        Matcher matcher;
        String string2 = string == null ? string : (string.startsWith("[") || string.startsWith("(") ? string : ((matcher = SNAPSHOT_TIMESTAMP.matcher(string)).matches() ? (matcher.group(1) != null ? matcher.group(1) + SNAPSHOT : SNAPSHOT) : string));
        return string2;
    }

    protected Artifact newInstance(String string, String string2, String string3, String string4, String string5, Map<String, String> map, File file) {
        return new DefaultArtifact(string, string2, string3, string4, string5, file, map);
    }

    @Override
    public Artifact setVersion(String string) {
        if (this.getVersion().equals(string)) {
            return this;
        }
        return this.newInstance(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), string, this.getProperties(), this.getFile());
    }

    @Override
    public Artifact setFile(File file) {
        if (AbstractArtifact.eq(this.getFile(), file)) {
            return this;
        }
        return this.newInstance(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), this.getVersion(), this.getProperties(), file);
    }

    @Override
    public Artifact setProperties(Map<String, String> map) {
        if (((Object)this.getProperties()).equals(map)) {
            return this;
        }
        return this.newInstance(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), this.getVersion(), AbstractArtifact.copy(map), this.getFile());
    }

    static Map<String, String> copy(Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            return new HashMap<String, String>(map);
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getGroupId());
        stringBuilder.append(':').append(this.getArtifactId());
        stringBuilder.append(':').append(this.getExtension());
        if (this.getClassifier().length() > 0) {
            stringBuilder.append(':').append(this.getClassifier());
        }
        stringBuilder.append(':').append(this.getVersion());
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)object;
        return this.getArtifactId().equals(artifact.getArtifactId()) && this.getGroupId().equals(artifact.getGroupId()) && this.getVersion().equals(artifact.getVersion()) && this.getExtension().equals(artifact.getExtension()) && this.getClassifier().equals(artifact.getClassifier()) && AbstractArtifact.eq(this.getFile(), artifact.getFile()) && ((Object)this.getProperties()).equals(artifact.getProperties());
    }

    private static <T> boolean eq(T t2, T t3) {
        return t2 != null ? t2.equals(t3) : t3 == null;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + this.getGroupId().hashCode();
        n2 = n2 * 31 + this.getArtifactId().hashCode();
        n2 = n2 * 31 + this.getExtension().hashCode();
        n2 = n2 * 31 + this.getClassifier().hashCode();
        n2 = n2 * 31 + this.getVersion().hashCode();
        n2 = n2 * 31 + AbstractArtifact.hash(this.getFile());
        return n2;
    }

    private static int hash(Object object) {
        return object != null ? object.hashCode() : 0;
    }
}

