/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.artifact;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.artifact.ArtifactType;
import zz.org.sonatype.aether.util.artifact.AbstractArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultArtifact
extends AbstractArtifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;
    private String baseVersion;

    public DefaultArtifact(String string) {
        this(string, Collections.emptyMap());
    }

    public DefaultArtifact(String string, Map<String, String> map) {
        Pattern pattern = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + string + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        this.groupId = matcher.group(1);
        this.artifactId = matcher.group(2);
        this.extension = DefaultArtifact.get(matcher.group(4), "jar");
        this.classifier = DefaultArtifact.get(matcher.group(6), "");
        this.version = matcher.group(7);
        this.file = null;
        this.properties = DefaultArtifact.copy(map);
    }

    private static String get(String string, String string2) {
        return string == null || string.length() <= 0 ? string2 : string;
    }

    public DefaultArtifact(String string, String string2, String string3, String string4) {
        this(string, string2, "", string3, string4);
    }

    public DefaultArtifact(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, string5, null, (File)null);
    }

    public DefaultArtifact(String string, String string2, String string3, String string4, String string5, ArtifactType artifactType) {
        this(string, string2, string3, string4, string5, null, artifactType);
    }

    public DefaultArtifact(String string, String string2, String string3, String string4, String string5, Map<String, String> map, ArtifactType artifactType) {
        this.groupId = DefaultArtifact.emptify(string);
        this.artifactId = DefaultArtifact.emptify(string2);
        this.classifier = string3 != null || artifactType == null ? DefaultArtifact.emptify(string3) : DefaultArtifact.emptify(artifactType.getClassifier());
        this.extension = string4 != null || artifactType == null ? DefaultArtifact.emptify(string4) : DefaultArtifact.emptify(artifactType.getExtension());
        this.version = DefaultArtifact.emptify(string5);
        this.file = null;
        this.properties = DefaultArtifact.merge(map, artifactType != null ? artifactType.getProperties() : null);
    }

    private static Map<String, String> merge(Map<String, String> map, Map<String, String> map2) {
        Map<String, String> map3;
        if ((map == null || map.isEmpty()) && (map2 == null || map2.isEmpty())) {
            map3 = Collections.emptyMap();
        } else {
            map3 = new HashMap();
            if (map2 != null) {
                map3.putAll(map2);
            }
            if (map != null) {
                map3.putAll(map);
            }
        }
        return map3;
    }

    public DefaultArtifact(String string, String string2, String string3, String string4, String string5, Map<String, String> map, File file) {
        this.groupId = DefaultArtifact.emptify(string);
        this.artifactId = DefaultArtifact.emptify(string2);
        this.classifier = DefaultArtifact.emptify(string3);
        this.extension = DefaultArtifact.emptify(string4);
        this.version = DefaultArtifact.emptify(string5);
        this.file = file;
        this.properties = DefaultArtifact.copy(map);
    }

    DefaultArtifact(String string, String string2, String string3, String string4, String string5, File file, Map<String, String> map) {
        this.groupId = DefaultArtifact.emptify(string);
        this.artifactId = DefaultArtifact.emptify(string2);
        this.classifier = DefaultArtifact.emptify(string3);
        this.extension = DefaultArtifact.emptify(string4);
        this.version = DefaultArtifact.emptify(string5);
        this.file = file;
        this.properties = map;
    }

    private static String emptify(String string) {
        return string == null ? "" : string;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getBaseVersion() {
        if (this.baseVersion == null) {
            this.baseVersion = DefaultArtifact.toBaseVersion(this.getVersion());
        }
        return this.baseVersion;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Artifact setVersion(String string) {
        if (this.version.equals(string) || string == null && this.version.length() <= 0) {
            return this;
        }
        return new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.extension, string, this.file, this.properties);
    }

    @Override
    public boolean isSnapshot() {
        return DefaultArtifact.isSnapshot(this.getVersion());
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Artifact setFile(File file) {
        if (this.file == null ? file == null : this.file.equals(file)) {
            return this;
        }
        return new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.extension, this.version, file, this.properties);
    }

    @Override
    public String getProperty(String string, String string2) {
        String string3 = this.properties.get(string);
        return string3 != null ? string3 : string2;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Artifact setProperties(Map<String, String> map) {
        if (((Object)this.properties).equals(map) || map == null && this.properties.isEmpty()) {
            return this;
        }
        return new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.extension, this.version, this.file, DefaultArtifact.copy(map));
    }
}

