/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.artifact;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.util.artifact.AbstractArtifact;
import zz.org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubArtifact
extends AbstractArtifact {
    private final Artifact mainArtifact;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;

    public SubArtifact(Artifact artifact, String string, String string2) {
        this(artifact, string, string2, (File)null);
    }

    public SubArtifact(Artifact artifact, String string, String string2, File file) {
        this(artifact, string, string2, null, file);
    }

    public SubArtifact(Artifact artifact, String string, String string2, Map<String, String> map) {
        this(artifact, string, string2, map, null);
    }

    public SubArtifact(Artifact artifact, String string, String string2, Map<String, String> map, File file) {
        if (artifact == null) {
            throw new IllegalArgumentException("no artifact specified");
        }
        this.mainArtifact = artifact;
        this.classifier = string;
        this.extension = string2;
        this.file = file;
        this.properties = SubArtifact.copy(map);
    }

    private SubArtifact(Artifact artifact, String string, String string2, File file, Map<String, String> map) {
        this.mainArtifact = artifact;
        this.classifier = string;
        this.extension = string2;
        this.file = file;
        this.properties = map;
    }

    @Override
    public String getGroupId() {
        return this.mainArtifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.mainArtifact.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.mainArtifact.getVersion();
    }

    @Override
    public Artifact setVersion(String string) {
        return new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), string, this.getFile(), this.getProperties());
    }

    @Override
    public String getBaseVersion() {
        return this.mainArtifact.getBaseVersion();
    }

    @Override
    public boolean isSnapshot() {
        return this.mainArtifact.isSnapshot();
    }

    @Override
    public String getClassifier() {
        return SubArtifact.expand(this.classifier, this.mainArtifact.getClassifier());
    }

    @Override
    public String getExtension() {
        return SubArtifact.expand(this.extension, this.mainArtifact.getExtension());
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Artifact setFile(File file) {
        if (this.file == null ? file == null : this.file.equals(file)) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, file, this.properties);
    }

    @Override
    public String getProperty(String string, String string2) {
        String string3 = this.properties.get(string);
        return string3 != null ? string3 : string2;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Artifact setProperties(Map<String, String> map) {
        if (((Object)this.properties).equals(map) || map == null && this.properties.isEmpty()) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, map, this.file);
    }

    private static String expand(String string, String string2) {
        String string3 = "";
        if (string != null) {
            string3 = string.replace("*", string2);
            if (string2.length() <= 0) {
                char c2;
                int n2;
                if (string.startsWith("*")) {
                    for (n2 = 0; n2 < string3.length() && ((c2 = string3.charAt(n2)) == '-' || c2 == '.'); ++n2) {
                    }
                    string3 = string3.substring(n2);
                }
                if (string.endsWith("*")) {
                    for (n2 = string3.length() - 1; n2 >= 0 && ((c2 = string3.charAt(n2)) == '-' || c2 == '.'); --n2) {
                    }
                    string3 = string3.substring(0, n2 + 1);
                }
            }
        }
        return string3;
    }
}

