/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.concurrency;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class RunnableErrorForwarder {
    private final Thread thread = Thread.currentThread();
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicReference<Throwable> error = new AtomicReference();

    public Runnable wrap(final Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable missing");
        }
        this.counter.incrementAndGet();
        return new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (RuntimeException runtimeException) {
                    RunnableErrorForwarder.this.error.compareAndSet(null, runtimeException);
                    throw runtimeException;
                }
                catch (Error error) {
                    RunnableErrorForwarder.this.error.compareAndSet(null, error);
                    throw error;
                }
                finally {
                    RunnableErrorForwarder.this.counter.decrementAndGet();
                    LockSupport.unpark(RunnableErrorForwarder.this.thread);
                }
            }
        };
    }

    public void await() {
        this.awaitTerminationOfAllRunnables();
        Throwable throwable = this.error.get();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof ThreadDeath) {
                throw new IllegalStateException(throwable);
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IllegalStateException(throwable);
        }
    }

    private void awaitTerminationOfAllRunnables() {
        boolean bl2 = false;
        while (this.counter.get() > 0) {
            LockSupport.park();
            if (!Thread.interrupted()) continue;
            bl2 = true;
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
    }
}

